/* just a demonstration how to use actionstack */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>

static void do_free(unsigned int, void *);

/* keys */
struct {
  int k_quit;
  int k_push;
  int k_get;
  int k_pop;
  int k_clear;
} kref;


/* free function for element-data */
static void
do_free(unsigned int name_id, void *vdata)
{
  if (vdata != NULL) {
    printf("REMOVE: %u:%s\n", name_id, (char *)vdata);
    free(vdata);
  }
}


int main(int argc, char **argv) {

  (void)argc; (void)argv;

  if (!VG_init("test")) { exit(1); }
  if (!vg4->window->open(VG_WINDOW_SIZE_LOW, VG_WINDOW_SCALE_NONE)) { VG_dest(); exit(1); }
  vg4->window->flush();

  /* set keys */
  if ((kref.k_quit = vg4->input->key_insert("Quit", VG_FALSE, VG_FALSE)) == 0) { VG_dest(); exit(1); }
  vg4->input->key_setkbd(kref.k_quit, VG_INPUT_KBDCODE_Q);
  if ((kref.k_push = vg4->input->key_insert("PUSH", VG_FALSE, VG_FALSE)) == 0) { VG_dest(); exit(1); }
  vg4->input->key_setkbd(kref.k_push, VG_INPUT_KBDCODE_UCURS);
  if ((kref.k_get = vg4->input->key_insert("GET+PARENT", VG_FALSE, VG_FALSE)) == 0) { VG_dest(); exit(1); }
  vg4->input->key_setkbd(kref.k_get, VG_INPUT_KBDCODE_SPACE);
  if ((kref.k_pop = vg4->input->key_insert("POP", VG_FALSE, VG_FALSE)) == 0) { VG_dest(); exit(1); }
  vg4->input->key_setkbd(kref.k_pop, VG_INPUT_KBDCODE_DCURS);
  if ((kref.k_clear = vg4->input->key_insert("CLEAR", VG_FALSE, VG_FALSE)) == 0) { VG_dest(); exit(1); }
  vg4->input->key_setkbd(kref.k_clear, VG_INPUT_KBDCODE_TAB);

  /* set free function */
  vg4->actionstack->freefunction(do_free);

  /* info */
  printf("\n");
  printf("Keys:\n");
  printf(" - quit:  Q\n");
  printf(" - push:  cursor up\n");
  printf(" - get:   space-key\n");
  printf(" - pop:   cursor down\n");
  printf(" - clear: tabulator\n");
  printf("\n");

  /* Gameloop */
  for (;;) {
    if (!vg4->input->update(VG_TRUE)) { break; }
    if (vg4->input->key_newpressed(kref.k_quit)) { break; }

    /* push element */
    if (vg4->input->key_newpressed(kref.k_push)) {
      /* element-data shall be just one of the following words */
      static char dbuf[][16] = { "the", "dog", "is", "running", "fast" };
      /* get a random name_id which shall correspond to the element-data */
      unsigned int name_id = vg4->random->get(NULL, 1, 5);
      /* push element */
      printf("ADD: %u:%s\n", name_id, dbuf[name_id - 1]);
      vg4->actionstack->push(name_id, strdup(dbuf[name_id - 1]));
    }

    /* get upmost and parent element */
    if (vg4->input->key_newpressed(kref.k_get)) {
      void *vdata;
      unsigned int name_id;
      printf("\n");
      vdata = vg4->actionstack->get(&name_id);
      if (name_id != 0) { printf("Upmost: %u:%s\n", name_id, (char *)vdata); }
      vdata = vg4->actionstack->parent(&name_id);
      if (name_id != 0) { printf("Parent: %u:%s\n", name_id, (char *)vdata); }
      printf("\n");
    }

    /* pop upmost element */
    if (vg4->input->key_newpressed(kref.k_pop)) {
      vg4->actionstack->pop();
    }

    /* clear actionstack */
    if (vg4->input->key_newpressed(kref.k_clear)) {
      vg4->actionstack->clear();
    }

    /* wait */
    vg4->misc->wait_time(50);
  }

  /* destroy and exit */
  VG_dest();
  exit(0);
}
