/* object-collision "BALL" against "BORDER" (and inverse) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <assert.h>
#include <vgagames4.h>
#include "pingpong.h"
#include "obj-ball.h"
#include "obj-border.h"

int objcoll_BALL_BORDER(void *, unsigned int, struct VG_Coll *);

int
objcoll_BALL_BORDER(void *vgame, unsigned int instanceid, struct VG_Coll *collb)
{
  struct VG_Object *objp;
  struct sobj_ball *objvars_ball;
  int xdelta, ydelta;
  int retw = VG_COLL_RETURN_CONTINUE;

  (void)vgame;

  /* only entering into collision is interesting here */
  if (collb->type != VG_COLL_TYPE_ENTRY) { return retw; }

  /* get private structure of moving object-instance */
  objp = vg4->object->instance_getobj(instanceid);
  { int erg = strcmp(objp->objid, "BALL"); assert(erg == 0); }  /* border doesn't move */
  objvars_ball = (struct sobj_ball *)objp->opriv;

  /* check collision sides of hit object-instance (border) */
  if (collb->side & VG_COLL_SIDE_LEFT) {
    vg4->misc->xy_from_angle(objvars_ball->angle, &xdelta, &ydelta);
    xdelta = -xdelta;
    objvars_ball->angle = vg4->misc->angle_from_xy(xdelta, ydelta, NULL);
    retw = VG_COLL_RETURN_STOP;  /* stop moving object-instance (ball) */
  }
  if (collb->side & (VG_COLL_SIDE_TOP | VG_COLL_SIDE_BOTTOM)) {
    vg4->misc->xy_from_angle(objvars_ball->angle, &xdelta, &ydelta);
    ydelta = -ydelta;
    objvars_ball->angle = vg4->misc->angle_from_xy(xdelta, ydelta, NULL);
    retw = VG_COLL_RETURN_STOP;  /* stop moving object-instance (ball) */
  }
  if (retw == VG_COLL_RETURN_STOP) { vg4->audio->play(objvars_ball->audc_hit, VG_FALSE, VG_FALSE); }

  return retw;
}
