/* object-collision "PLAYER" against "BORDER" (and inverse) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <assert.h>
#include <vgagames4.h>
#include "pingpong.h"
#include "obj-player.h"
#include "obj-border.h"

int objcoll_PLAYER_BORDER(void *, unsigned int, struct VG_Coll *);

int
objcoll_PLAYER_BORDER(void *vgame, unsigned int instanceid, struct VG_Coll *collb)
{
  struct VG_Object *objp;
  int retw = VG_COLL_RETURN_CONTINUE;

  (void)vgame;

  /* only entering into collision is interesting here */
  if (collb->type != VG_COLL_TYPE_ENTRY) { return retw; }

  /* get moving object-instance */
  objp = vg4->object->instance_getobj(instanceid);
  { int erg = strcmp(objp->objid, "PLAYER"); assert(erg == 0); }  /* border doesn't move */

  retw = VG_COLL_RETURN_STOP;  /* stop moving object-instance (player) */

  return retw;
}
