/* connect to network-server */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>

int connect_to_nwserver(int, int);

static void show_progress(const char * const *, int, void *);


/* callback-function for showing progress at connecting to network-server */
static void
show_progress(const char * const *clients, int anz, void *vdata)
{    
  int i1;
  char btxt[512];
  size_t blen;
  struct VG_Image *img;
  char *sdata = (char *)vdata;

  /* create text containing the clients in a list */
  if (sdata != NULL) { snprintf(btxt, sizeof(btxt), "%s:\n", sdata); }
  blen = strlen(btxt);
  for (i1 = 0; i1 < anz; i1++) {
    snprintf(btxt + blen, sizeof(btxt) - blen, " - <%s>\n", clients[i1]);
    blen = strlen(btxt);
  }

  /* show text */
  img = vg4->font->totext(btxt, NULL, NULL, NULL, NULL);
  vg4->window->clear();
  vg4->window->copy(img, NULL, NULL);
  vg4->window->flush();
  vg4->image->destroy(img);
}


/* connect to network-server
 * @param min_connections  min. connections
 * @param max_connections  max. connections
 * @return  local client-number or 0 = connection failed
 */
int
connect_to_nwserver(int min_connections, int max_connections)
{
  char remhost[128], *ipsrv;
  int clnr;

  /* get IP of network-server */
  ipsrv = vg4->nw->get_ip(remhost, sizeof(remhost));
  if (ipsrv == NULL) { return 0; }
  printf("Found network-server \"%s\" [%s]\n", remhost, ipsrv);

  /* connect to network-server, blocking until all clients connected, showing progress */
  clnr = vg4->nw->connect(ipsrv, min_connections, max_connections, NULL, show_progress, "Connected");
  free(ipsrv);
  if (clnr <= 0) { return 0; }

  return clnr;
}
