/* draw a multilanguage text onto the window */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>

int main(int argc, char **argv) {
  struct VG_Image *imgp;
  const char *txt1, *txt2;
  char ntext[256];

  (void)argc; (void)argv;

  /* initialize and open window */
  if (!VG_init("test")) { exit(1); }
  if (!vg4->window->open(VG_WINDOW_SIZE_LOW, VG_WINDOW_SCALE_NONE)) { VG_dest(); exit(1); }

  /* set english as fallback */
  vg4->mlang->fb_locale("en");

  /* add multilanguage entries from mlang/ */
  vg4->mlang->add("mlang");

  /* get two multilanguage entries from scope "game" */
  txt1 = vg4->mlang->get("game", "joke_question");
  txt2 = vg4->mlang->get("game", "joke_answer");

  /* create text-image from the two strings */
  snprintf(ntext, sizeof(ntext), "%s\n\n%s", txt1, txt2);
  imgp = vg4->font->totext(ntext, NULL, NULL, NULL, NULL);
  if (imgp == NULL) { VG_dest(); exit(1); }

  /* output to window */
  vg4->window->clear();
  vg4->window->copy(imgp, NULL, NULL);
  vg4->window->flush();
  vg4->image->destroy(imgp);

  sleep(5);

  /* destroy and exit */
  VG_dest();
  exit(0);
}
