/* move a sunnyboy on a background greater than the window */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>

/* keys */
struct {
  int k_quit;
  int k_left;
  int k_right;
  int k_forward;
  int k_backward;
} kref;

int main(int argc, char **argv) {
  const int sb_movefactor = 15;
  const int sb_turnfactor = 5;
  struct {  /* sunnyboy's structure */
    struct VG_Image *imgp;
    struct VG_RectCent rectc;
    int angle;
  } sb;
  struct VG_Image *bgimg;
  int bgwidth, bgheight;
  int do_move;

  (void)argc; (void)argv;

  /* initialize and open window */
  if (!VG_init("test")) { exit(1); }
  if (!vg4->window->open(VG_WINDOW_SIZE_LOW, VG_WINDOW_SCALE_BEST)) { VG_dest(); exit(1); }

  /* set keys */
  if ((kref.k_quit = vg4->input->key_insert("Quit", VG_FALSE, VG_FALSE)) == 0) { VG_dest(); exit(1); }
  vg4->input->key_setkbd(kref.k_quit, VG_INPUT_KBDCODE_Q);
  if ((kref.k_left = vg4->input->key_insert("Left", VG_FALSE, VG_FALSE)) == 0) { VG_dest(); exit(1); }
  vg4->input->key_setkbd(kref.k_left, VG_INPUT_KBDCODE_LCURS);
  if ((kref.k_right = vg4->input->key_insert("Right", VG_FALSE, VG_FALSE)) == 0) { VG_dest(); exit(1); }
  vg4->input->key_setkbd(kref.k_right, VG_INPUT_KBDCODE_RCURS);
  if ((kref.k_forward = vg4->input->key_insert("Forward", VG_FALSE, VG_FALSE)) == 0) { VG_dest(); exit(1); }
  vg4->input->key_setkbd(kref.k_forward, VG_INPUT_KBDCODE_UCURS);
  if ((kref.k_backward = vg4->input->key_insert("Backward", VG_FALSE, VG_FALSE)) == 0) { VG_dest(); exit(1); }
  vg4->input->key_setkbd(kref.k_backward, VG_INPUT_KBDCODE_DCURS);

  /* load background-image and get size */
  bgimg = vg4->image->load("background.bmp");
  if (bgimg == NULL) { VG_dest(); exit(1); }
  vg4->image->getsize(bgimg, NULL, &bgwidth, &bgheight);

  /* initialize background-positioning: velocity 2 pixels, centered rectangle 60% of the window */
  vg4->misc->bgposition_init(bgwidth, bgheight, 2, 60);

  /* load sunnyboy and set its rectangle centered on the background */
  sb.imgp = vg4->image->load("sunnyboy.bmp");
  if (sb.imgp == NULL) { VG_dest(); exit(1); }
  vg4->image->getsize(sb.imgp, NULL, &sb.rectc.rect.w, &sb.rectc.rect.h);
  sb.rectc.rect.x = (bgwidth - sb.rectc.rect.w) / 2;
  sb.rectc.rect.y = (bgheight - sb.rectc.rect.h) / 2;
  sb.rectc.centx = sb.rectc.centy = 0;
  sb.angle = 0;

  /* game loop */
  for (;;) {
    if (!vg4->input->update(VG_TRUE)) { break; }
    if (vg4->input->key_newpressed(kref.k_quit)) { break; }

    /* check for key-strokes */

    do_move = 0;

    /* turn left */
    if (vg4->input->key_pressed(kref.k_left)) {
      sb.angle -= sb_turnfactor;
      sb.angle %= 360; sb.angle += 360; sb.angle %= 360;
    }

    /* turn right */
    if (vg4->input->key_pressed(kref.k_right)) {
      sb.angle += sb_turnfactor;
      sb.angle %= 360; sb.angle += 360; sb.angle %= 360;
    }

    /* go forward */
    if (vg4->input->key_pressed(kref.k_forward)) {
      do_move++;
    }

    /* go backward */
    if (vg4->input->key_pressed(kref.k_backward)) {
      do_move--;
    }

    /* move if requested */

    if (do_move != 0) {
      int anz_rectcpos;
      struct VG_RectCent *rectc_pos;

      if (do_move > 0) {  /* forward */
        anz_rectcpos = vg4->misc->moving_one_step(&sb.rectc, sb.angle, sb_movefactor, &rectc_pos);
      } else {  /* backward */
        anz_rectcpos = vg4->misc->moving_one_step(&sb.rectc, sb.angle, -sb_movefactor, &rectc_pos);
      }

      /* we are only interested in the last position */
      if (anz_rectcpos > 0) {
        sb.rectc = rectc_pos[anz_rectcpos - 1];
      }
      if (rectc_pos != NULL) { free(rectc_pos); }

      /* check for boundaries */
      if (sb.rectc.rect.x < 0) { sb.rectc.rect.x = 0; }
      if (sb.rectc.rect.x > bgwidth - sb.rectc.rect.w) { sb.rectc.rect.x = bgwidth - sb.rectc.rect.w; }
      if (sb.rectc.rect.y < 0) { sb.rectc.rect.y = 0; }
      if (sb.rectc.rect.y > bgheight - sb.rectc.rect.h) { sb.rectc.rect.y = bgheight - sb.rectc.rect.h; }
    }

    /* draw out */

    vg4->window->clear();

    /* draw background */
    { struct VG_Position posi;
      /* get position of background according to sunnyboy */
      vg4->misc->bgposition_getbg(&sb.rectc.rect, &posi, VG_FALSE);
      vg4->window->copy(bgimg, &posi, NULL);
    }

    /* draw sunnyboy */
    { struct VG_ImagecopyAttr iattr;
      struct VG_Position posi;
      VG_IMAGECOPY_ATTR_DEFAULT(&iattr);
      iattr.image.rotate = sb.angle;  /* set rotation */
      /* get position from rectangle and correct it according to background-position */
      vg4->misc->rect2position(&posi, &sb.rectc.rect);
      posi = vg4->misc->bgposition_getobj(posi);
      vg4->window->copy(sb.imgp, &posi, &iattr);
    }

    vg4->window->flush();
    vg4->misc->wait_time(50);
  }

  /* destroy and exit */
  VG_dest();
  exit(0);
}
