/* connect to network-server */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>

VG_BOOL connect_to_nwserver(int, int *, int *);

static void show_progress(const char * const *, int, void *);


/* callback-function for showing progress at connecting to network-server */
static void
show_progress(const char * const *clients, int anz, void *vdata)
{    
  int i1;
  char btxt[512];
  size_t blen;
  struct VG_Image *img;
  char *sdata = (char *)vdata;

  /* create text containing the clients in a list */
  if (sdata != NULL) { snprintf(btxt, sizeof(btxt), "%s:\n", sdata); }
  blen = strlen(btxt);
  for (i1 = 0; i1 < anz; i1++) {
    snprintf(btxt + blen, sizeof(btxt) - blen, " - %d = <%s>\n", i1+1, clients[i1]);
    blen = strlen(btxt);
  }

  /* show text */
  img = vg4->font->totext(btxt, NULL, NULL, NULL, NULL);
  vg4->window->clear();
  vg4->window->copy(img, NULL, NULL);
  vg4->window->flush();
  vg4->image->destroy(img);
}


/* connect to network-server
 * @param max_connections  max. connections
 * @param clnr   for returning local client-number
 * @param clmax  for returning number of clients
 * @return  VG_TRUE = OK or VG_FALSE = error
 */
VG_BOOL
connect_to_nwserver(int max_connections, int *clnr, int *clmax)
{
  char remhost[128], *ipsrv;

  if (clnr == NULL || clmax == NULL) { return VG_FALSE; }

  /* get IP of network-server */
  ipsrv = vg4->nw->get_ip(remhost, sizeof(remhost));
  if (ipsrv == NULL) { return VG_FALSE; }

  /* connect to network-server, blocking until all clients connected, showing progress */
  *clnr = vg4->nw->connect(ipsrv, 0, max_connections, NULL, show_progress, "Clients");
  free(ipsrv);
  if (*clnr <= 0) { return VG_FALSE; }

  /* get number of clients */
  *clmax = vg4->nw->numberofclients(NULL);

  return VG_TRUE;
}
