#ifndef SPRITE_H_
#define SPRITE_H_

#include "vgi.h"

enum { SPRITE_AUDIOFLAG_STOP = 0, SPRITE_AUDIOFLAG_WAIT, SPRITE_AUDIOFLAG_LOOPING };

struct vgi_sprite {  /* sprite struct */
  char *fname;                       /* filename */
  char dirname[VGI_PATHSIZE];        /* correction of path for files to load */
  struct SML3_hash *himg;            /* shared images (SHA1-value) */
  struct SML3_hash *hsnd;            /* shared audio-file-id (SHA1-value) */
  int lifetime, mom_life;            /* number of cycles or 0 = infinite, actual cycle-number */
  int dfl_nloop, mom_nloop;          /* default game-loop-number, actual game-loop-number */
  int anz_elem, mom_elem;            /* number of sprite-element, actual active element */
  struct {                           /* sprite-elements */
    int anz_nloop;                     /* individual game-loop-number of 0 = dfl_nloop */
    struct VG_Image *img;              /* image (reference to himg) or NULL = no image */
    struct VG_ImagecopyAttr iattr;     /* attributes for image */
    int audc;                          /* audio-descriptor (reference to hsnd) or 0 = no audio */
    int audioflag;                     /* audio-flag (one of SPRITE_AUDIOFLAG_*) */
  } *e;
};

struct VG_Sprite {
  struct VG_Sprite *prev, *next;
  struct vgi_sprite spre;
};

#endif /* SPRITE_H_ */
