/* Copyright 2022-2026 Kurt Nienhaus
 *
 * This file is part of VgaGames.
 * VgaGames is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * VgaGames is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with VgaGames.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "misc.h"

void init_misc_base64(void);

static void misc_base64_encode(char **, size_t *, const char *, size_t);
static void misc_base64_decode(char **, size_t *, const char *, size_t);


/* set functions */
void
init_misc_base64(void)
{
  vg4->misc->base64_encode = misc_base64_encode;
  vg4->misc->base64_decode = misc_base64_decode;
} /* Ende init_misc_base64 */


/* misc_base64_encode:
 * encode data into base64-data
 * @param encdata  for returning encoded data (with terminating 0)
 * @param encsize  for returning number of bytes in encdata (without terminating 0)
 * @param data     data to encode
 * @param size     number of bytes in data
 */
static void
misc_base64_encode(char **encdata, size_t *encsize, const char *data, size_t size)
{
  if (encdata != NULL) { *encdata = NULL; }
  if (encsize != NULL) { *encsize = 0; }

  if (encdata == NULL || encsize == NULL || data == NULL || size == 0) { return; }

  SML3_base64_encode(encdata, encsize, data, size, 0, NULL);
} /* Ende misc_base64_encode */


/* misc_base64_decode:
 * decode data from base64-data
 * @param decdata  for returning decoded data (with terminating 0)
 * @param decsize  for returning number of bytes in decdata (without terminating 0)
 * @param data     data to decode
 * @param size     number of bytes in data
 */
static void
misc_base64_decode(char **decdata, size_t *decsize, const char *data, size_t size)
{
  if (decdata != NULL) { *decdata = NULL; }
  if (decsize != NULL) { *decsize = 0; }

  if (decdata == NULL || decsize == NULL || data == NULL || size == 0) { return; }

  SML3_base64_decode(decdata, decsize, data, size, NULL);
} /* Ende misc_base64_decode */
