#ifndef INPUT_H_
#define INPUT_H_

#include "vgi.h"

#define GCNAME_SIZE    64
#define KEYNAME_SIZE   32

struct vgi_input {  /* input struct */
  struct {  /* found gamecontrollers */
    int max;  /* number of gamecontrollers */
    struct {  /* gamecontrollers */
      char name[GCNAME_SIZE];  /* name */
    } gc[VG_MAX_GCS];
  } gcs;

  struct {  /* keys */
    int max;  /* number of entries */
    struct {  /* entry */
      int keyref;                  /* reference */
      VG_BOOL menu;                /* whether is changeable e.g. in a menu */
      VG_BOOL nw;                  /* whether is network-key */
      int pressed;                 /* status how is pressed (0 = no, 1 = yes, 2 = yes and queried) */
      char name[KEYNAME_SIZE];     /* description */
      struct {                     /* devices */
        struct {                     /* keyboard */
          int code;                    /* one of VG_INPUT_KBDCODES */
          VG_BOOL ispres, isnew;       /* whether is pressed, whether is new */
        } kbd;
        struct {                     /* gamecontrollers */
          struct {                     /* gamecontroller */
            int code;                    /* one of VG_INPUT_GCBUTTONS or VG_INPUT_GCAXES */
            VG_BOOL ispres, isnew;       /* whether is pressed, whether is new */
          } gc[VG_MAX_GCS];
        } gcs;
      } devs;
    } *e;
  } keys;

  struct {  /* mouse */
    VG_BOOL grab_enabled;     /* whether is grabbing is enabled */
    VG_BOOL grabbed;          /* whether is grabbed in window */
    int x, y;                 /* position */
    int left, middle, right;  /* buttons (pressed? 0 = no, 1 = yes, 2 = yes and queried) */
  } mouse;

  struct {  /* text input */
    char *tptr;           /* pointer to text buffer, or NULL */
    size_t tsize;         /* text buffer size */
    char *c_yes;          /* allowed characters */
    char *c_no;           /* not allowed characters */
  } text;
};

#endif /* INPUT_H_ */
