#ifndef IMAGE_H_
#define IMAGE_H_

#include "vgi.h"

struct vgi_image {
  char *fname;                   /* filename or NULL */
  int w, h;                      /* width and height */
  VG_BOOL nolist;                /* whether was loaded with vg4_image_load_nolist() */
  VG_BOOL isrdonly;              /* whether is read-only */
  VG_BOOL hasopq;                /* whether has opaque pixels */
  VG_BOOL isclear;               /* whether all pixels are opaque = 0 */
  struct VG_PixelColor *pixels;  /* pixels (row = width, col = height) */
};

struct VG_Image {
  struct VG_Image *prev, *next;
  struct vgi_image img;
};

extern void image_modif_rotatesize(int *, int *, int);
extern struct VG_Image * image_modif_rotflip(const struct VG_Image *, int, int, VG_BOOL);
extern struct VG_Image * image_modif_zoom(const struct VG_Image *, int, int, VG_BOOL);

#endif /* IMAGE_H_ */
