#ifndef FONT_H_
#define FONT_H_

#include "vgi.h"

struct vgi_font {     /* font character */
  int w, h;             /* width and height */
  unsigned char *data;  /* font character data */
};

#define VGI_FONT_SEPSPACE 32
#define VGI_FONT_SEPC_MAX 3
struct VG_Font {
  char name[64];                /* font name */
  int sepc[VGI_FONT_SEPC_MAX];  /* additional word-separation-UTF8-characters besides space */
  int maxw, maxh;               /* greatest width and height */
  int gaptop, gapbottom;        /* common empty lines at top and bottom */
  struct VG_Hash *hfont;        /* font characters (key = UTF8-index, value = struct vgi_font) */
};

extern void init_font_text(void);

#endif /* FONT_H_ */
