#ifndef FILM_H_
#define FILM_H_

#include "vgi.h"

struct vgi_film_story_picture {  /* a single picture of a film-story */
  int imgcnt_idx;                  /* index of loaded image or -1 */
  struct VG_Position posi;
  int zoom;
  int rotate;
  int bright;
  int opaque;
  int flip;
};

struct vgi_film_story_sound {  /* a sound of a film-story */
  int audc;                      /* audio-descriptor */
  int pic_no;                    /* picture number to play */
};

struct vgi_film_music {  /* music */
  int audc;                /* audio-descriptor */
  int pic_no;              /* picture number to play */
  VG_BOOL looping;         /* play looping? */
  VG_BOOL cresc;           /* starting with crescendo? */
  VG_BOOL toend;           /* if not looping: wait until ended? */
};

struct vgi_film {  /* film struct */
  int floop;
  VG_BOOL fadeout;
  int bgcolor;
  int scale_promille;
  int pic_pos;
  struct VG_Image *wimg;

  struct {  /* loaded images, sounds and musics */
    int anz_img;
    struct vgi_imgcnt *imgcntp;
    int anz_audio;
    int *audcp;
  } loaded;

  struct {  /* musics */
    int anz;
    int mus_pos;
    struct vgi_film_music *mus;
  } music;

  struct {           /* story struct */
    int anz;
    struct story_elem {  /* stories */
      char *name;          /* filename */
      int drawlevel;       /* level-number for drawing order (begins with 1 = lowest level) */
      int pic_start;       /* picture start number */
      int anz_pic;         /* number of pictures */
      int *anz_picp;       /* number of parallel pictures for each picture */
      struct vgi_film_story_picture **pic;
      int anz_snd;         /* number of sounds */
      int snd_pos;         /* next position in snd */
      struct vgi_film_story_sound *snd;
    } *e;
  } story;
};

#endif /* FILM_H_ */
