/* Copyright 2022-2026 Kurt Nienhaus
 *
 * This file is part of VgaGames.
 * VgaGames is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * VgaGames is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with VgaGames.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "vgi.h"

char * oggexec(const char *);


char *
oggexec(const char *file)
{
  static char oggpath[VGI_PATHSIZE] = "";

#ifdef VGI_DISABLE_OGG
  outerr("No support for ogg compiled in (%s)", file);
  return NULL;
#endif

  if (file == NULL || *file == '\0') { outerr("no file given"); return NULL; }

  snprintf(oggpath, sizeof(oggpath), "%s/share/vgagames4/libexec/vgag-ogg %s",
           vg4_get_prefix(NULL), file);

  return oggpath;
} /* Ende oggexec */
