/* Copyright 2022-2026 Kurt Nienhaus
 *
 * This file is part of VgaGames.
 * VgaGames is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * VgaGames is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with VgaGames.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "vgi.h"

char * mp3exec(int, int, int, const char *);


char *
mp3exec(int bitsize, int channels, int freq, const char *file)
{
  static char mp3path[VGI_PATHSIZE] = "";
  const char *param_bitsize, *param_channels;

#ifdef VGI_DISABLE_MP3
  outerr("No support for mp3 compiled in (%s)", file);
  return NULL;
#endif

  if (file == NULL || *file == '\0') { outerr("no file given"); return NULL; }

  param_bitsize = "";
  if (bitsize == 8) { param_bitsize = "--8bit"; }

  param_channels = "--mono";
  if (channels == 2) { param_channels = "--stereo"; }

  snprintf(mp3path, sizeof(mp3path), "%s/share/vgagames4/libexec/vgag-mp3 %s %s -r %d -q -s %s 2>/dev/null",
           vg4_get_prefix(NULL), param_bitsize, param_channels, freq, file);

  return mp3path;
} /* Ende mp3exec */
