#ifndef IOLIB_H_
#define IOLIB_H_

#include <SDL3/SDL.h>
#include "symbols.h"
#include "vgi.h"

struct iolib {  /* struct for SDL3-support */

  void *dlib;           /* loaded SDL3-library */
  struct symbols syms;  /* found SDL3-functions */

  struct {              /* struct for input-functions */
    VG_BOOL wfocus;       /* whether window has focus */
    struct {              /* gamecontrollers */
      SDL_JoystickID jid;   /* joystick ID */
      SDL_Gamepad *gctl;    /* gamecontroller struct */
    } gc[VG_MAX_GCS];
    struct {              /* mapping input codes */
      SDL_Scancode *kmap;       /* keyboard */
      SDL_GamepadButton *bmap;  /* GC: buttons */
      SDL_GamepadAxis *amap;    /* GC: axes */
      int *aval;                /* GC: direction of axes */
    } codes;
  } input;

  struct {              /* struct for window-functions */
    SDL_Window *wd;               /* window */
    SDL_PropertiesID props;       /* window-properties */
    int bestfactor;               /* factor for VG_WINDOW_SCALE_BEST */
    SDL_Renderer *renderer;       /* renderer of window */
    SDL_PixelFormat pixelformat;  /* pixelformat of window */
    SDL_Texture *btex;            /* backbuffer texture */
    SDL_Surface *bsurf;           /* surface for pixelformat of backbuffer texture */
  } window;

  struct {              /* struct for audio-functions */
    SDL_AudioStream *astrm;  /* audio stream */
    SDL_AudioStream *aconv;  /* audio converter stream */
    SDL_AudioSpec adev_in;   /* audio specifications input */
    SDL_AudioSpec adev_out;  /* audio specifications output */
  } audio;
};

extern void init_input_sdl3(void);
extern void init_window_sdl3(void);
extern void init_audio_sdl3(void);
extern void init_image_sdl3(void);

#endif /* IOLIB_H_ */
