/* definitions of the SDL3-functions
 * DEFSYM(<Return>, <Function>, (<Parameters>))
 * e.g.
 *   void SDL_GetVersion(SDL_version* ver)
 *   => DEFSYM(void, SDL_GetVersion, (SDL_version*))
 */

DEFSYM(int,                             SDL_AddGamepadMapping, (const char *))
DEFSYM(void,                            SDL_CloseGamepad, (SDL_Gamepad *))
DEFSYM(SDL_Surface *,                   SDL_ConvertSurface, (SDL_Surface *, SDL_PixelFormat))
DEFSYM(SDL_AudioStream *,               SDL_CreateAudioStream, (const SDL_AudioSpec *, const SDL_AudioSpec *))
DEFSYM(SDL_PropertiesID,                SDL_CreateProperties, (void))
DEFSYM(SDL_Renderer *,                  SDL_CreateRenderer, (SDL_Window *, const char *))
DEFSYM(SDL_Surface *,                   SDL_CreateSurface, (int, int, SDL_PixelFormat))
DEFSYM(SDL_Texture *,                   SDL_CreateTexture, (SDL_Renderer *, SDL_PixelFormat, SDL_TextureAccess, int, int))
DEFSYM(SDL_Window *,                    SDL_CreateWindowWithProperties, (SDL_PropertiesID))
DEFSYM(void,                            SDL_DestroyAudioStream, (SDL_AudioStream *))
DEFSYM(void,                            SDL_DestroyProperties, (SDL_PropertiesID))
DEFSYM(void,                            SDL_DestroyRenderer, (SDL_Renderer *))
DEFSYM(void,                            SDL_DestroySurface, (SDL_Surface *))
DEFSYM(void,                            SDL_DestroyTexture, (SDL_Texture *))
DEFSYM(void,                            SDL_DestroyWindow, (SDL_Window *))
DEFSYM(bool,                            SDL_DisableScreenSaver, (void))
DEFSYM(void,                            SDL_free, (void *))
DEFSYM(bool,                            SDL_GetAudioDeviceFormat, (SDL_AudioDeviceID, SDL_AudioSpec *, int *))
DEFSYM(int,                             SDL_GetAudioStreamAvailable, (SDL_AudioStream *))
DEFSYM(int,                             SDL_GetAudioStreamData, (SDL_AudioStream *, void *, int))
DEFSYM(SDL_AudioDeviceID,               SDL_GetAudioStreamDevice, (SDL_AudioStream *))
DEFSYM(const char *,                    SDL_GetCurrentAudioDriver, (void))
DEFSYM(bool,                            SDL_GetDisplayBounds, (SDL_DisplayID, SDL_Rect *))
DEFSYM(SDL_DisplayID *,                 SDL_GetDisplays, (int *))
DEFSYM(const char *,                    SDL_GetError, (void))
DEFSYM(Sint16,                          SDL_GetGamepadAxis, (SDL_Gamepad *, SDL_GamepadAxis))
DEFSYM(bool,                            SDL_GetGamepadButton, (SDL_Gamepad *, SDL_GamepadButton))
DEFSYM(SDL_GUID,                        SDL_GetGamepadGUIDForID, (SDL_JoystickID))
DEFSYM(const char *,                    SDL_GetGamepadName, (SDL_Gamepad *))
DEFSYM(SDL_JoystickID *,                SDL_GetJoysticks, (int *))
DEFSYM(const bool *,                    SDL_GetKeyboardState, (int *))
DEFSYM(SDL_Keycode,                     SDL_GetKeyFromScancode, (SDL_Scancode, SDL_Keymod, bool))
DEFSYM(SDL_MouseButtonFlags,            SDL_GetMouseState, (float *, float *))
DEFSYM(int,                             SDL_GetNumRenderDrivers, (void))
DEFSYM(const SDL_PixelFormatDetails *,  SDL_GetPixelFormatDetails, (SDL_PixelFormat format))
DEFSYM(const char *,                    SDL_GetPlatform, (void))
DEFSYM(void *,                          SDL_GetPointerProperty, (SDL_PropertiesID, const char *, void *))
DEFSYM(const char *,                    SDL_GetRenderDriver, (int))
DEFSYM(const char *,                    SDL_GetRendererName, (SDL_Renderer *))
DEFSYM(SDL_PropertiesID,                SDL_GetRendererProperties, (SDL_Renderer *))
DEFSYM(void,                            SDL_GetRGBA, (Uint32, const SDL_PixelFormatDetails *, const SDL_Palette *, Uint8 *, Uint8 *, Uint8 *, Uint8 *))
DEFSYM(SDL_Palette *,                   SDL_GetSurfacePalette, (SDL_Surface *surface))
DEFSYM(SDL_WindowFlags,                 SDL_GetWindowFlags, (SDL_Window *))
DEFSYM(bool,                            SDL_GetWindowMouseGrab, (SDL_Window *))
DEFSYM(bool,                            SDL_GetWindowSize, (SDL_Window *, int *, int *))
DEFSYM(void,                            SDL_GUIDToString, (SDL_GUID, char *, int))
DEFSYM(bool,                            SDL_HideCursor, (void))
DEFSYM(bool,                            SDL_Init, (SDL_InitFlags))
DEFSYM(SDL_IOStream *,                  SDL_IOFromFile, (const char *, const char *))
DEFSYM(SDL_IOStream *,                  SDL_IOFromMem, (void *, size_t))
DEFSYM(bool,                            SDL_IsGamepad, (SDL_JoystickID))
DEFSYM(SDL_Surface *,                   SDL_LoadBMP_IO, (SDL_IOStream *, bool))
DEFSYM(bool,                            SDL_LoadWAV_IO, (SDL_IOStream *, bool, SDL_AudioSpec *, Uint8 **, Uint32 *))
DEFSYM(bool,                            SDL_LockAudioStream, (SDL_AudioStream *))
DEFSYM(bool,                            SDL_LockTexture, (SDL_Texture *, const SDL_Rect *, void **, int *))
DEFSYM(Uint32,                          SDL_MapSurfaceRGBA, (SDL_Surface *, Uint8, Uint8, Uint8, Uint8))
DEFSYM(SDL_AudioStream *,               SDL_OpenAudioDeviceStream, (SDL_AudioDeviceID, const SDL_AudioSpec *, SDL_AudioStreamCallback, void *))
DEFSYM(SDL_Gamepad *,                   SDL_OpenGamepad, (SDL_JoystickID))
DEFSYM(bool,                            SDL_PollEvent, (SDL_Event *))
DEFSYM(bool,                            SDL_PushEvent, (SDL_Event *))
DEFSYM(bool,                            SDL_PutAudioStreamData, (SDL_AudioStream *, const void *, int))
DEFSYM(void,                            SDL_Quit, (void))
DEFSYM(bool,                            SDL_RenderClear, (SDL_Renderer *))
DEFSYM(bool,                            SDL_RenderPresent, (SDL_Renderer *))
DEFSYM(bool,                            SDL_RenderTexture, (SDL_Renderer *, SDL_Texture *, const SDL_FRect *, const SDL_FRect *))
DEFSYM(bool,                            SDL_ResumeAudioStreamDevice, (SDL_AudioStream *))
DEFSYM(bool,                            SDL_SaveBMP_IO, (SDL_Surface *, SDL_IOStream *, bool))
DEFSYM(bool,                            SDL_ScreenSaverEnabled, (void))
DEFSYM(bool,                            SDL_SetAppMetadata, (const char *, const char *, const char *))
DEFSYM(bool,                            SDL_SetBooleanProperty, (SDL_PropertiesID, const char *, bool))
DEFSYM(void,                            SDL_SetEventEnabled, (Uint32, bool))
DEFSYM(bool,                            SDL_SetNumberProperty, (SDL_PropertiesID, const char *, Sint64))
DEFSYM(bool,                            SDL_SetRenderDrawColor, (SDL_Renderer *, Uint8, Uint8, Uint8, Uint8))
DEFSYM(bool,                            SDL_SetRenderLogicalPresentation, (SDL_Renderer *, int, int, SDL_RendererLogicalPresentation))
DEFSYM(bool,                            SDL_SetStringProperty, (SDL_PropertiesID, const char *, const char *))
DEFSYM(bool,                            SDL_SetSurfaceBlendMode, (SDL_Surface *, SDL_BlendMode))
DEFSYM(bool,                            SDL_SetTextureBlendMode, (SDL_Texture *, SDL_BlendMode))
DEFSYM(bool,                            SDL_SetTextureScaleMode, (SDL_Texture *, SDL_ScaleMode))
DEFSYM(bool,                            SDL_SetWindowKeyboardGrab, (SDL_Window *, bool))
DEFSYM(bool,                            SDL_SetWindowMouseGrab, (SDL_Window *, bool))
DEFSYM(bool,                            SDL_ShowCursor, (void))
DEFSYM(bool,                            SDL_StartTextInput, (SDL_Window *))
DEFSYM(bool,                            SDL_StopTextInput, (SDL_Window *))
DEFSYM(bool,                            SDL_UnlockAudioStream, (SDL_AudioStream *))
DEFSYM(void,                            SDL_UnlockTexture, (SDL_Texture *))
DEFSYM(void,                            SDL_WarpMouseInWindow, (SDL_Window *, float, float))
