#ifndef IOLIB_H_
#define IOLIB_H_

#include <SDL.h>
#include "symbols.h"
#include "vgi.h"

struct iolib {  /* struct for SDL2-support */

  void *dlib;           /* loaded SDL2-library */
  struct symbols syms;  /* found SDL2-functions */

  struct {              /* struct for input-functions */
    VG_BOOL wfocus;       /* whether window has focus */
    struct {              /* gamecontrollers */
      SDL_JoystickID jid;        /* joystick ID */
      SDL_GameController *gctl;  /* gamecontroller struct */
    } gc[VG_MAX_GCS];
    struct {            /* mapping input codes */
      SDL_Scancode *kmap;              /* keyboard */
      SDL_GameControllerButton *bmap;  /* GC: buttons */
      SDL_GameControllerAxis *amap;    /* GC: axes */
      int *aval;                       /* GC: direction of axes */
    } codes;
  } input;

  struct {              /* struct for window-functions */
    SDL_Window *wd;          /* window */
    int bestfactor;          /* factor for VG_WINDOW_SCALE_BEST */
    SDL_Renderer *renderer;  /* renderer of window */
    Uint32 pixelformatenum;  /* pixelformat of window */
    SDL_Texture *btex;       /* backbuffer texture */
    SDL_Surface *bsurf;      /* surface for pixelformat of backbuffer texture */
  } window;

  struct {              /* struct for audio-functions */
    SDL_AudioDeviceID aid;   /* audio device ID */
    SDL_AudioSpec adev;      /* audio specifications */
  } audio;
};

extern void init_input_sdl2(void);
extern void init_window_sdl2(void);
extern void init_audio_sdl2(void);
extern void init_image_sdl2(void);

#endif /* IOLIB_H_ */
