/* definitions of the SDL2-functions
 * DEFSYM(<Return>, <Function>, (<Parameters>))
 * e.g.
 *   void SDL_GetVersion(SDL_version* ver)
 *   => DEFSYM(void, SDL_GetVersion, (SDL_version*))
 */

DEFSYM(void,                  SDL_CloseAudioDevice, (SDL_AudioDeviceID))
DEFSYM(SDL_Surface *,         SDL_ConvertSurfaceFormat, (SDL_Surface *, Uint32, Uint32))
DEFSYM(SDL_Renderer *,        SDL_CreateRenderer, (SDL_Window *, int, Uint32))
DEFSYM(SDL_Surface *,         SDL_CreateRGBSurface, (Uint32, int, int, int, Uint32, Uint32, Uint32, Uint32))
DEFSYM(SDL_Texture *,         SDL_CreateTexture, (SDL_Renderer *, Uint32, int, int, int))
DEFSYM(SDL_Window *,          SDL_CreateWindow, (const char *, int, int, int, int, Uint32))
DEFSYM(void,                  SDL_DestroyRenderer, (SDL_Renderer *))
DEFSYM(void,                  SDL_DestroyTexture, (SDL_Texture *))
DEFSYM(void,                  SDL_DestroyWindow, (SDL_Window *))
DEFSYM(void,                  SDL_DisableScreenSaver, (void))
DEFSYM(Uint8,                 SDL_EventState, (Uint32, int))
DEFSYM(void,                  SDL_FreeSurface, (SDL_Surface *))
DEFSYM(void,                  SDL_FreeWAV, (Uint8 *))
DEFSYM(int,                   SDL_GameControllerAddMapping, (const char *))
DEFSYM(void,                  SDL_GameControllerClose, (SDL_GameController *))
DEFSYM(Sint16,                SDL_GameControllerGetAxis, (SDL_GameController *, SDL_GameControllerAxis))
DEFSYM(Uint8,                 SDL_GameControllerGetButton, (SDL_GameController *, SDL_GameControllerButton))
DEFSYM(SDL_Joystick *,        SDL_GameControllerGetJoystick, (SDL_GameController *))
DEFSYM(const char *,          SDL_GameControllerName, (SDL_GameController *))
DEFSYM(SDL_GameController *,  SDL_GameControllerOpen, (int))
DEFSYM(const char *,          SDL_GetCurrentAudioDriver, (void))
DEFSYM(int,                   SDL_GetDisplayBounds, (int, SDL_Rect *))
DEFSYM(const char *,          SDL_GetError, (void))
DEFSYM(const Uint8 *,         SDL_GetKeyboardState, (int *))
DEFSYM(SDL_Keycode,           SDL_GetKeyFromScancode, (SDL_Scancode))
DEFSYM(Uint32,                SDL_GetMouseState, (int *, int *))
DEFSYM(int,                   SDL_GetNumRenderDrivers, (void))
DEFSYM(int,                   SDL_GetNumVideoDisplays, (void))
DEFSYM(const char *,          SDL_GetPlatform, (void))
DEFSYM(int,                   SDL_GetRenderDriverInfo, (int, SDL_RendererInfo *))
DEFSYM(int,                   SDL_GetRendererInfo, (SDL_Renderer *, SDL_RendererInfo *))
DEFSYM(void,                  SDL_GetRGBA, (Uint32, const SDL_PixelFormat *, Uint8 *, Uint8 *, Uint8 *, Uint8 *))
DEFSYM(Uint32,                SDL_GetWindowFlags, (SDL_Window *))
DEFSYM(SDL_bool,              SDL_GetWindowGrab, (SDL_Window *))
DEFSYM(void,                  SDL_GetWindowSize, (SDL_Window *, int *, int *))
DEFSYM(int,                   SDL_Init, (Uint32))
DEFSYM(SDL_bool,              SDL_IsGameController, (int))
DEFSYM(SDL_bool,              SDL_IsScreenSaverEnabled, (void))
DEFSYM(SDL_JoystickGUID,      SDL_JoystickGetDeviceGUID, (int))
DEFSYM(void,                  SDL_JoystickGetGUIDString, (SDL_JoystickGUID, char *, int))
DEFSYM(SDL_JoystickID,        SDL_JoystickInstanceID, (SDL_Joystick *))
DEFSYM(SDL_Surface *,         SDL_LoadBMP_RW, (SDL_RWops *, int))
DEFSYM(SDL_AudioSpec *,       SDL_LoadWAV_RW, (SDL_RWops *, int, SDL_AudioSpec *, Uint8 **, Uint32 *))
DEFSYM(void,                  SDL_LockAudioDevice, (SDL_AudioDeviceID))
DEFSYM(int,                   SDL_LockTexture, (SDL_Texture *, const SDL_Rect *, void **, int *))
DEFSYM(Uint32,                SDL_MapRGBA, (const SDL_PixelFormat *, Uint8, Uint8, Uint8, Uint8))
DEFSYM(int,                   SDL_NumJoysticks, (void))
DEFSYM(SDL_AudioDeviceID,     SDL_OpenAudioDevice, (const char *, int, const SDL_AudioSpec *, SDL_AudioSpec *, int))
DEFSYM(void,                  SDL_PauseAudioDevice, (SDL_AudioDeviceID, int))
DEFSYM(int,                   SDL_PollEvent, (SDL_Event *))
DEFSYM(int,                   SDL_PushEvent, (SDL_Event *))
DEFSYM(void,                  SDL_Quit, (void))
DEFSYM(int,                   SDL_RenderClear, (SDL_Renderer *))
DEFSYM(int,                   SDL_RenderCopy, (SDL_Renderer *, SDL_Texture *, const SDL_Rect *, const SDL_Rect *))
DEFSYM(void,                  SDL_RenderPresent, (SDL_Renderer *))
DEFSYM(int,                   SDL_RenderSetIntegerScale, (SDL_Renderer *, SDL_bool))
DEFSYM(int,                   SDL_RenderSetLogicalSize, (SDL_Renderer *, int, int))
DEFSYM(int,                   SDL_RWclose, (SDL_RWops *))
DEFSYM(SDL_RWops *,           SDL_RWFromFile, (const char *, const char *))
DEFSYM(SDL_RWops *,           SDL_RWFromMem, (void *, int))
DEFSYM(int,                   SDL_SaveBMP_RW, (SDL_Surface *, SDL_RWops *, int))
DEFSYM(SDL_bool,              SDL_SetHint, (const char *, const char *))
DEFSYM(int,                   SDL_SetRenderDrawColor, (SDL_Renderer *, Uint8, Uint8, Uint8, Uint8))
DEFSYM(int,                   SDL_SetSurfaceBlendMode, (SDL_Surface *, SDL_BlendMode))
DEFSYM(int,                   SDL_SetTextureBlendMode, (SDL_Texture *, SDL_BlendMode))
DEFSYM(void,                  SDL_SetWindowGrab, (SDL_Window *, SDL_bool))
DEFSYM(int,                   SDL_ShowCursor, (int))
DEFSYM(void,                  SDL_StartTextInput, (void))
DEFSYM(void,                  SDL_StopTextInput, (void))
DEFSYM(void,                  SDL_UnlockAudioDevice, (SDL_AudioDeviceID))
DEFSYM(void,                  SDL_UnlockTexture, (SDL_Texture *))
DEFSYM(void,                  SDL_WarpMouseInWindow, (SDL_Window *, int, int))
