#ifndef QUADTREE_H_
#define QUADTREE_H_

#include "bitfld.h"

struct vgi_qt_obj {  /* inserted object */
  unsigned int instanceid;  /* instance-ID */
  int percent;              /* percent of original size of object */
  struct VG_Rect rect;      /* position */
};

struct vgi_quadtree {  /* quadtree */
# define QUADTREE_QUAD 4
  struct vgi_quadtree *nodes[QUADTREE_QUAD];
  struct SML3_hash *hrel;
  struct SML3_hash *hobjid;
  unsigned int tag;
  int level;
  int max_rect, max_level;
  struct VG_Rect bounds;
  struct vgi_bitfld bf, *bfall;
  struct {
    int objanz;
    struct vgi_qt_obj *obj;
  } *objs;
};


extern void quadtree_init(struct vgi_quadtree *, unsigned int, const struct VG_Rect *, int, int);
extern void quadtree_dest(struct vgi_quadtree *);
extern void quadtree_clear(struct vgi_quadtree *);
extern void quadtree_insert(struct vgi_quadtree *, unsigned int, const struct VG_Rect *, int);
extern void quadtree_remove(struct vgi_quadtree *, unsigned int);
extern int quadtree_setpos(struct vgi_quadtree *, unsigned int, const struct VG_Rect *, struct VG_Coll **);
extern void quadtree_mark(struct vgi_quadtree *, struct VG_Image *, int, const char *);
extern void quadtree_dump(FILE *, struct vgi_quadtree *);

#endif /* QUADTREE_H_ */
