#ifndef AUDIO_H_
#define AUDIO_H_

#include "vgi.h"

#define CRESDIM_SEK   4      /* seconds for (de-)crescendo */
#define MAX_AUDIO     99     /* max. number loaded audio streams */

struct vgi_audio {  /* audio struct */
  /* device info */
  int bitsize;      /* bitsize (one of VG_AUDIO_BITSIZES) */
  int freq;         /* frequency */
  VG_BOOL stereo;   /* VG_FALSE = mono, VG_TRUE = stereo */

  /* callback function */
  void (*cbf)(void *, unsigned char *, int);

  /* volumes */
  unsigned char mainvol, volg[VG_AUDIO_VOLUME_MAXENUM - 1];
  VG_BOOL ismute;     /* whether is mute */
  VG_BOOL issuspend;  /* whether audio output is suspended */

  /* audio mixer buffer */
  union {
    long l;
    double d;
  } *mixbuf;
  unsigned char *ebuf;
  int mixsize;

  /* shared WAVE data */
  struct wv_data {
    char *key;     /* key */
    char *data;    /* WAVE data */
    int dsize;     /* number of bytes in data */
    int anzref;    /* number of references to this struct-element */
  } wvdata[MAX_AUDIO];

  /* audio streams */
  struct {
    unsigned char vgidx;   /* index of volume-group (volg[vgidx])) */
    unsigned char voladj;  /* volume-adjustment */
    int waitaudc;          /* audio-descriptor to wait before start playing, or 0 */
    int crmom, crmax;      /* (de-)crescendo: actual and maximal value */
    VG_BOOL issys;         /* whether is system-sound */
    VG_BOOL nolist;        /* whether was loaded with vg4_audio_load_nolist() */
    VG_BOOL doloop;        /* whether loop audio */
    VG_BOOL isstopping;    /* whether is stopping */
    VG_BOOL ispaused;      /* whether is paused */
    VG_BOOL isext;         /* whether playing uses external program */
    union {                /* data */
      struct {               /* internal (WAVE) */
        char *key;             /* key (for wvdata) */
        unsigned char *start;  /* pointer to sound-data start */
        unsigned char *dbuf;   /* pointer to actual playing data */
        int size;              /* number of bytes sound-data */
        int dlen;              /* number of bytes for dbuf */
      } i;
      struct {               /* external program */
        char *key;             /* key */
        char *file[2];         /* external program: [0]=noloop, [1]=loop */
        FILE *ffp;             /* file pointer to running program */
      } e;
    } u;
  } d[MAX_AUDIO];
};

#endif /* AUDIO_H_ */
