#ifdef PATCFG_TIMIDITY

static char tmidi_cfg[]="\
bank 0\n\
    0 Acoustic_Grand_Piano.pat amp=120 pan=center\n\
    1 Acoustic_Brite_Piano.pat\n\
    2 Electric_Grand_Piano.pat\n\
    3 sologrnd.pat strip=tail\n\
    4 Electric_Piano_1_Rhodes.pat\n\
    5 Electric_Piano_2_Chorused_Yamaha_DX.pat\n\
    6 Harpsichord.pat\n\
    7 Clavinet.pat\n\
    8 Celesta.pat\n\
    9 Glockenspiel.pat\n\
   10 sologrnd.pat\n\
   11 sologrnd.pat\n\
   12 sologrnd.pat strip=loop\n\
   13 Xylophone.pat\n\
   14 Tubular_Bells.pat\n\
   15 Dulcimer.pat\n\
   16 Hammond_Organ.pat\n\
   17 sologrnd.pat\n\
   18 sologrnd.pat\n\
   19 Church_Organ.pat\n\
   20 sologrnd.pat\n\
   21 Accordion.pat\n\
   22 sologrnd.pat\n\
   23 Tango_Accordion.pat\n\
   24 Nylon_Guitar.pat\n\
   25 Steel_Guitar.pat\n\
   26 Jazz_Guitar.pat\n\
   27 Clean_Electric_Guitar.pat\n\
   28 Muted_Electric_Guitar.pat\n\
   29 Overdriven_Guitar.pat\n\
   30 Distortion_Guitar.pat\n\
   31 nylongt2.pat\n\
   32 Acoustic_Bass.pat\n\
   33 Finger_Bass.pat\n\
   34 Pick_Bass.pat\n\
   35 Fretless_Bass.pat\n\
   36 Slap_Bass_1.pat\n\
   37 Slap_Bass_2.pat\n\
   38 Synth_Bass_1.pat\n\
   39 acbass.pat\n\
   40 Violin.pat\n\
   41 nylongt2.pat strip=env\n\
   42 Cello.pat\n\
   43 acbass.pat strip=env\n\
   44 Tremolo_Strings.pat\n\
   45 Pizzicato_Strings.pat\n\
   46 Harp.pat\n\
   47 Timpani.pat\n\
   48 String_Ensemble_1_Marcato.pat\n\
   49 nylongt2.pat strip=env\n\
   50 nylongt2.pat strip=env\n\
   51 nylongt2.pat strip=env\n\
   52 sologrnd.pat\n\
   53 Voice_Oohs.pat\n\
   54 sologrnd.pat\n\
   55 sologrnd.pat\n\
   56 Trumpet.pat\n\
   57 Trombone.pat\n\
   58 Tuba.pat\n\
   59 Muted_Trumpet.pat\n\
   60 French_Horn.pat\n\
   61 Brass_Section.pat\n\
   62 sologrnd.pat\n\
   63 sologrnd.pat\n\
   64 Soprano_Sax.pat\n\
   65 Alto_Sax.pat\n\
   66 Tenor_Sax.pat\n\
   67 Baritone_Sax.pat\n\
   68 Oboe.pat\n\
   69 English_Horn.pat\n\
   70 Bassoon.pat\n\
   71 Clarinet.pat\n\
   72 Piccolo.pat\n\
   73 Flute.pat\n\
   74 Recorder.pat\n\
   75 Pan_Flute.pat\n\
   76 Bottle_Blow.pat\n\
   77 sologrnd.pat\n\
   78 sologrnd.pat\n\
   79 Ocarina.pat\n\
   80 Square_Wave.pat\n\
   81 sologrnd.pat\n\
   82 sologrnd.pat\n\
   83 sologrnd.pat\n\
   84 Charang.pat\n\
   85 sologrnd.pat\n\
   86 sologrnd.pat\n\
   87 sologrnd.pat\n\
   88 New_Age.pat\n\
   89 sologrnd.pat\n\
   90 sologrnd.pat\n\
   91 sologrnd.pat\n\
   92 sologrnd.pat\n\
   93 sologrnd.pat\n\
   94 Halo_Pad.pat\n\
   95 Sweep_Pad.pat\n\
   96 sologrnd.pat\n\
   97 sologrnd.pat\n\
   98 Crystal.pat\n\
   99 sologrnd.pat\n\
  100 sologrnd.pat\n\
  101 Goblins__Unicorn.pat\n\
  102 Echo_Voice.pat\n\
  103 nylongt2.pat\n\
  104 Sitar.pat\n\
  105 nylongt2.pat\n\
  106 nylongt2.pat\n\
  107 nylongt2.pat\n\
  108 nylongt2.pat\n\
  109 sologrnd.pat\n\
  110 sologrnd.pat strip=env\n\
  111 sologrnd.pat\n\
  112 sologrnd.pat\n\
  113 sologrnd.pat\n\
  114 Steel_Drums.pat\n\
  115 Wood_Block.pat\n\
  116 sologrnd.pat strip=loop\n\
  117 sologrnd.pat strip=loop\n\
  118 sologrnd.pat strip=loop\n\
  119 sologrnd.pat strip=loop\n\
  120 Guitar_Fret_Noise.pat\n\
  121 sologrnd.pat\n\
  122 Seashore.pat\n\
  123 sologrnd.pat\n\
  124 sologrnd.pat\n\
  125 Helicopter.pat\n\
  126 sologrnd.pat\n\
  127 sologrnd.pat\n\
\n\
drumset 0\n\
   25 Snare_Roll.pat\n\
   26 Snap.pat\n\
   27 High_Q.pat\n\
   31 Sticks.pat\n\
   32 Square_Click.pat\n\
   33 Metronome_Click.pat\n\
   34 Metronome_Bell.pat\n\
   35 Kick_1.pat amp=100\n\
   36 Kick_2.pat amp=100\n\
   37 Stick_Rim.pat\n\
   38 Snare_1.pat\n\
   39 Clap_Hand.pat amp=100\n\
   40 Snare_2.pat\n\
   41 Tom_Low_2.pat amp=100\n\
   42 Hi_Hat_Closed.pat\n\
   43 Tom_Low_1.pat amp=100\n\
   44 Hi_Hat_Pedal.pat\n\
   45 Tom_Mid_2.pat amp=100\n\
   46 Hi_Hat_Open.pat\n\
   47 Tom_Mid_1.pat amp=100\n\
   48 Tom_High_2.pat amp=100\n\
   49 Cymbal_Crash_1.pat\n\
   50 Tom_High_1.pat amp=100\n\
   51 Cymbal_Ride_1.pat\n\
   52 Cymbal_Chinese.pat\n\
   53 Cymbal_Ride_Bell.pat amp=100\n\
   54 Tombourine.pat\n\
   55 Cymbal_Splash.pat\n\
   56 Cow_Bell.pat\n\
   57 Cymbal_Crash_2.pat\n\
   58 Vibra_Slap.pat\n\
   59 Cymbal_Ride_2.pat\n\
   60 Bongo_High.pat\n\
   61 Bongo_Low.pat\n\
   62 Conga_High_1_Mute.pat\n\
   63 Conga_High_2_Open.pat\n\
   64 Conga_Low.pat\n\
   65 Timbale_High.pat\n\
   66 Timbale_Low.pat\n\
   67 Agogo_High.pat\n\
   68 Agogo_Low.pat\n\
   69 Cabasa.pat amp=100\n\
   70 Maracas.pat\n\
   71 Whistle_1_High_Short.pat\n\
   72 Whistle_2_Low_Long.pat\n\
   73 Guiro_1_Short.pat\n\
   74 Guiro_2_Long.pat\n\
   75 Claves.pat amp=100\n\
   76 Wood_Block_1_High.pat\n\
   77 Wood_Block_2_Low.pat\n\
   78 Cuica_1_Mute.pat amp=100\n\
   79 Cuica_2_Open.pat amp=100\n\
   80 Triangle_1_Mute.pat\n\
   81 Triangle_2_Open.pat\n\
   82 Shaker.pat\n\
   84 Belltree.pat\n\
";

#else  /* !PATCFG_TIMIDITY */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

extern char pgdir[256];

static void
get_patchname(const char *name, char **nptr, size_t *nlen)
{
  int fd;
  char patfile[384];
  struct stat sbuf;

  if (nptr == NULL || nlen == NULL) { return; }
  *nptr = NULL; *nlen = 0;
  if (name == NULL || *name == '\0') { return; }

  snprintf(patfile, sizeof(patfile), "%s/tmidi-pats/%s", pgdir, name);
  fd = open(patfile, O_RDONLY);
  if (fd < 0) { fprintf(stderr, "open %s: %s\n", patfile, strerror(errno)); return; }
  if (fstat(fd, &sbuf) < 0) { fprintf(stderr, "fstat %s: %s\n", patfile, strerror(errno)); close(fd); return; }

  *nlen = (size_t)sbuf.st_size;
  *nptr = malloc(*nlen);
  if (*nptr == NULL) { fprintf(stderr, "malloc for %s: %s\n", patfile, strerror(errno)); close(fd); return; }

  if (read(fd, *nptr, *nlen) != (ssize_t)*nlen) {
    fprintf(stderr, "short read of %s\n", patfile);
    close(fd);
    free(*nptr);
    return;
  }

  close(fd);
} /* Ende get_patchname */

#endif  /* PATCFG_TIMIDITY */
