/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    support.c - Define missing function
                Written by Masanao Izumo <mo@goice.co.jp>
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include "config.h"
#ifdef HAVE_SYS_SELECT_H
# include <sys/select.h>
#endif


int u_sleep(unsigned int usec)
{
    struct timeval tv;
    usec-=TIME_OF_SELECT*1000;
    if (usec<=0) {
      tv.tv_sec  = 0;
      tv.tv_usec = 1;
    } else {
      tv.tv_sec  = usec / 1000000;
      tv.tv_usec = usec % 1000000;
    }
    select(0, NULL, NULL, NULL, &tv);
    return(0);
}


/*
 * Copyright (c) 1998 Todd C. Miller <Todd.Miller@courtesan.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Copy src to string dst of size siz.  At most siz-1 characters
 * will be copied.  Always NUL terminates (unless siz == 0).
 * Returns strlen(src); if retval >= siz, truncation occurred.
 */
size_t tmidi_strlcpy(char * dst,const char * src,size_t siz) {
  register char * d=dst;
  register const char * s=src;
  register size_t n=siz;

  /* Copy as many bytes as will fit */
  if (n!=0 && --n!=0) {
    do {
      if ((*d++ = *s++)==0) {break;}
    } while (--n != 0);
  }

  /* Not enough room in dst, add NUL and traverse rest of src */
  if (n==0) {
    if (siz!=0) {*d='\0';}  /* NUL-terminate dst */
    while (*s++) {;}
  }

  return(s-src-1);  /* count does not include NUL */
}

/*
 * Appends src to string dst of size siz (unlike strncat, siz is the
 * full size of dst, not space left).  At most siz-1 characters
 * will be copied.  Always NUL terminates (unless siz <= strlen(dst)).
 * Returns strlen(src) + MIN(siz, strlen(initial dst)).
 * If retval >= siz, truncation occurred.
 */
size_t tmidi_strlcat(char * dst,const char * src,size_t siz) {
  register char * d=dst;
  register const char * s=src;
  register size_t n=siz;
  size_t dlen;

  /* Find the end of dst and adjust bytes left but don't go past end */
  while (n-- != 0 && *d!='\0') {d++;}
    dlen=d-dst;
    n=siz-dlen;

    if (n==0) {return(dlen+strlen(s));}
    while (*s!='\0') {
      if (n!=1) {
        *d++=*s;
        n--;
      }
      s++;
    }
    *d='\0';

    return(dlen + (s - src));  /* count does not include NUL */
}
