#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

static int
tos(void)
{
  struct timeval tv;
  int ms, ws, i1;
  if (gettimeofday(&tv, NULL) !=0 ) { return 1; }
  ms = (tv.tv_sec % 60) * 1000 + tv.tv_usec / 1000;
  for (i1 = 0; i1 < 100; i1++) {
    tv.tv_usec = 10000;
    tv.tv_sec = 0;
    select(0, NULL, NULL, NULL, &tv);
  }
  if (gettimeofday(&tv, NULL) != 0) { return 1; }
  ws = (tv.tv_sec % 60) * 1000 + tv.tv_usec / 1000;
  if (ws < ms) { ws += 60000; }
  ws -= ms;
  ws -= 1000;
  ws /= 100;
  return ws;
}


int
main(void)
{
  union {
    short a;
    char b[2];
  } ue;

  ue.a = 1;
  if (ue.b[0] == 1) {
    printf("#define ENDIAN_IS_LITTLE\n");
  } else {
    printf("#define ENDIAN_IS_BIG\n");
  }

  if (sizeof(long) == 8) {
    printf("#define LONG8_BIT\n");
  }

  printf("#define TIME_OF_SELECT %d\n", tos());

  printf("#include \"support.h\"\n");

  exit(0);
}
