#ifndef SML3__STRING_H
#define SML3__STRING_H

/* ++++++++++++++++++++
 * +++ Beschreibung +++
 * ++++++++++++++++++++

 Enthaelt verschiedene Funktionen fuer Strings
+++ */


/* ++++++++++++++++++ */
/* +++ Funktionen +++ */
/* ++++++++++++++++++ */

/** SML3_string_toks [thread-sicher]:
 * gibt Teilstring aus String zurueck, auch leere Teilstrings
 * 1.Arg: Adresse auf String, wird aktualisiert
 * 2.Arg: Auswahl von Zeichen als Trenner
 * 3.Arg: fuer Rueckgabe Teilstring
 * Rueckgabe: Pointer auf Inhalt vom 3.Arg
 *            oder NULL = Ende
 * Bsp:
 *  struct SML3_gummi gm = SML3_GUM_INITIALIZER;
 *  const char *saveptr, *string = "a:b;c:;d";
 *  char *tstring;
 *  saveptr = string;
 *  while ((tstring = SML3_string_toks(&saveptr, ":;", &gm)) != NULL) {
 *    printf("<%s> ", tstring);
 *  }
 *  printf("\n");
 *  SML3_gumdest(&gm);
 *  ==> Ausgabe: <a> <b> <c> <> <d>
 */
extern char * SML3_string_toks(const char **, const char *, struct SML3_gummi *);


/* SML3_string_split [thread-sicher]:
 * splittet einen String auf in ein Feld
 * 1.Arg: String
 * 2.Arg: >0: maximale Anzahl Feldelemente inklusive leere
 *         0: alle, leere uebergehen
 *        -1: alle, auch leere
 * 3.Arg: Regulaerer Trennausdruck
 * 4.Arg: SML3_REXFLAG_* Flags: SML3_REXFLAG_Q, SML3_REXFLAG_I, SML3_REXFLAG_N
 * Rueckgabe: NULL-terminiertes alloziertes Feld
 *            oder NULL = Fehler
 * SML3-errno-Wert: EINVAL = Fehler Uebergabeparameter
 *                  ENOMEM  = Allokationsfehler
 *                  ENOEXEC = Compilierungsfehler des regulaeren Trennausdrucks
 *
 * Bsp:
 *   char **feld, **pptr;
 *   feld = SML3_string_split("SML3_string_split", -1, "[si]", SML3_REXFLAG_I);
 *   if (feld == NULL) { fprintf(stderr, "%s\n", SML3_fehlermsg()); exit(1); }
 *   for (pptr = feld; *pptr != NULL; pptr++) { printf("<%s> ", *pptr); }
 *   printf("\n");
 *   SML3_freefeld(feld, NULL);
 *  ==> Ausgabe: <> <ML3_> <tr> <ng_> <pl> <t>
 */
extern char ** SML3_string_split(const char *, int, const char *, int);


/** SML3_string_twosplit [thread-sicher]:
 * splittet einen String jeweils zwischen 2 Trennern auf in ein Feld
 * 1.Arg: String
 * 2.Arg: >0: maximale Anzahl Feldelemente inklusive leere
 *         0: alle, leere uebergehen
 *        -1: alle, auch leere
 * 3.Arg: Regulaerer Trennausdruck fuer Starttrenner
 * 4.Arg: SML3_REXFLAG_* Flags: SML3_REXFLAG_Q, SML3_REXFLAG_I, SML3_REXFLAG_N
 * 5.Arg: Regulaerer Trennausdruck fuer Endetrenner
 * 6.Arg: SML3_REXFLAG_* Flags: SML3_REXFLAG_Q, SML3_REXFLAG_I, SML3_REXFLAG_N
 * Rueckgabe: NULL-terminiertes alloziertes Feld
 *            oder NULL = Fehler
 * SML3-errno-Wert: EINVAL = Fehler Uebergabeparameter
 *                  ENOMEM  = Allokationsfehler
 *                  ENOEXEC = Compilierungsfehler des regulaeren Trennausdrucks
 *
 * Bsp:
 *   char **feld, **pptr;
 *   feld = SML3_string_twosplit("eins <zwei drei> vier <fuenf> sechs", -1, "<", 0, ">", 0);
 *   if (feld == NULL) { fprintf(stderr, "%s\n", SML3_fehlermsg()); exit(1); }
 *   for (pptr = feld; *pptr != NULL; pptr++) { printf("<%s> ", *pptr); }
 *   printf("\n");
 *   SML3_freefeld(feld, NULL);
 *  ==> Ausgabe: <zwei drei> <fuenf>
 */
extern char ** SML3_string_twosplit(const char *, int, const char *, int, const char *, int);


/** SML3_string_join [ohne Callback-Funktion: thread-sicher]:
 * fuegt ein Feld in einen String zusammen
 * 1.Arg: NULL-terminiertes Feld
 * 2.Arg: im String zu setzender Trenner zwischen Feldelementen oder NULL = keine
 * 3.Arg: Bitwert:
 *        Bit 0 (Wert 1): Trenner 2.Arg auch am Anfang und Ende setzen
 *        Bit 1 (Wert 2): leere Feldelemente uebergehen
 * 4.Arg: Funktion zum Veraendern des Feldelements, bevor es eingefuegt wird
 *          1.Parameter: Feldelement
 *          2.Parameter: fuer Rueckgabe veraendertes Feldelement
 *          Rueckgabe: 0 = Feldelement uebergehen, 1 = veraendertes Feldelement einfuegen
 *        oder NULL = keine Funktion
 * Rueckgabe: allozierter String
 */
extern char * SML3_string_join(char **, const char *, int, int (*)(const char *, struct SML3_gummi *));

#endif /* SML3__STRING_H */
