#ifndef SML3__ESCAPESEQ_H_
#define SML3__ESCAPESEQ_H_

/* ++++++++++++++++++++
 * +++ Beschreibung +++
 * ++++++++++++++++++++

  SML3_excapeseq_convert() verarbeitet Escapesequenzen in einem String
  SML3_escapeseq_next() verarbeitet die aktuelle Escapesequenz
+++ */


/* ++++++++++++++++
 * +++ Beispiel +++
 * ++++++++++++++++

  #include <stdio.h>
  #include <stdlib.h>
  #include <string.h>
  #include <sys/types.h>
  #include <unistd.h>
  #include <errno.h>
  #include <sammel3.h>

  int main(void) {
    struct SML3_gummi gm = SML3_GUM_INITIALIZER;
    char buf[32];
    SML3_strlcpy(buf, "H\\x61nn\\x65s", sizeof(buf));
    SML3_escapeseq_convert(buf, strlen(buf), &gm, 0);
    // Ausgabe: "H\x61nn\x65s" => "Hannes"
    printf("\"%s\" => \"%s\"\n", buf, SML3_gumgetval(&gm));
    SML3_gumdest(&gm);
    exit(0);
  }
+++ */


/* ++++++++++++++++++ */
/* +++ Funktionen +++ */
/* ++++++++++++++++++ */

#include <sys/types.h>


/** SML3_escapeseq_convert [thread-sicher]:
 * verarbeitet Escape-Sequenzen
 * 1.Arg: zu bearbeitender String
 * 2.Arg: Anzahl zu bearbeitende Zeichen im 1.Arg
 * 3.Arg: Rueckgabe-Gummistring fuer bearbeiteten String (erhaelt Ende-0)
 * 4.Arg: Beginnposition Rueckgabe-Gummistring
 * Rueckgabe: Anzahl Zeichen im Gummistring ab 4.Arg
 */
extern size_t SML3_escapeseq_convert(const char *, size_t, struct SML3_gummi *, size_t);


/** SML3_escapeseq_next [thread-sicher]:
 * verarbeitet naechste Escape-Sequenz, falls 1.Arg mit Backslash beginnt
 * 1.Arg: String
 * 2.Arg: Anzahl Zeichen im 1.Arg
 * 3.Arg: Rueckgabe fuer verarbeitetes Escape-Zeichen
 * Rueckgabe: > 0: Laenge der Escape-Sequenz im 1.Arg
 *              0: keine oder unvollstaendige Escape-Sequenz im 1.Arg
 *
 * Escape-Sequenzen:
 *  - \a \b \f \n \r \t \v \' \" \\ \?
 *  - \0<bis 3 Stellen: Zahl>: Oktalwert
 *  - \[xX]<bis 2 Stellen: [0-9a-fA-F]>: Hexwert
 *  - bei nicht erkannten wird \ entfernt
 */
extern size_t SML3_escapeseq_next(const char *, size_t, char *);

#endif /* SML3__ESCAPESEQ_H_ */
