#ifndef SML3__CKSUM_H
#define SML3__CKSUM_H

/* ++++++++++++++++++++
 * +++ Beschreibung +++
 * ++++++++++++++++++++

 Enthaelt Funktionen fuer Checksummen-Berechnung
+++ */


/* ++++++++++++++++
 * +++ Beispiel +++
 * ++++++++++++++++

  #include <stdio.h>
  #include <stdlib.h>
  #include <string.h>
  #include <sys/types.h>
  #include <unistd.h>
  #include <errno.h>
  #include <sammel3.h>

  int main(int argc, char **argv) {
    void *cksum;
    char buf[128 + 1];  // 128 ist Mindestgroesse fuer sha2-512
    size_t slen;

  #if 0
    cksum = SML3_cksum_init(SML3_CKSUM_DIGEST_MD5);  // Beispiel fuer MD5
  #else
    cksum = SML3_cksum_hmac_init(SML3_CKSUM_DIGEST_SHA2_512, "geheimerKey", 11);  // Beispiel fuer HMAC-SHA2-512
  #endif

    while ((slen = fread(buf, 1, sizeof(buf), stdin)) > 0) {
      SML3_cksum_add(cksum, buf, slen);
    }

    printf("%s\n", SML3_cksum_result(cksum, buf, sizeof(buf)));

    exit(0);
  }
+++ */


/* ++++++++++++++++++ */
/* +++ Funktionen +++ */
/* ++++++++++++++++++ */

#include <sys/types.h>

/* Checksummen-Digest */
#define SML3_CKSUM_DIGEST_HORNER2    1  /* Horner-Pruefsumme (2-stellig) */
#define SML3_CKSUM_DIGEST_HORNER3    2  /* Horner-Pruefsumme (3-stellig) */
#define SML3_CKSUM_DIGEST_HORNER4    3  /* Horner-Pruefsumme (4-stellig) */
#define SML3_CKSUM_DIGEST_HORNER5    4  /* Horner-Pruefsumme (5-stellig) */
#define SML3_CKSUM_DIGEST_HORNER6    5  /* Horner-Pruefsumme (6-stellig) */
#define SML3_CKSUM_DIGEST_HORNER7    6  /* Horner-Pruefsumme (7-stellig) */
#define SML3_CKSUM_DIGEST_HORNER8    7  /* Horner-Pruefsumme (8-stellig) */
#define SML3_CKSUM_DIGEST_HORNER9    8  /* Horner-Pruefsumme (9-stellig) */
#define SML3_CKSUM_DIGEST_MD5       10  /* MD5 (32-stellig) */
#define SML3_CKSUM_DIGEST_SHA1      20  /* SHA-1 (40-stellig) */
#define SML3_CKSUM_DIGEST_SHA2_224  31  /* SHA-2-224 (56-stellig) */
#define SML3_CKSUM_DIGEST_SHA2_256  32  /* SHA-2-256 (64-stellig) */
#define SML3_CKSUM_DIGEST_SHA2_384  33  /* SHA-2-384 (96-stellig) */
#define SML3_CKSUM_DIGEST_SHA2_512  34  /* SHA-2-512 (128-stellig) */


/** SML3_cksum_init [thread-sicher]:
 * Checksummen-Berechnung: Initialisierung
 * 1.Arg: Checksummen-Digest (SML3_CKSUM_DIGEST_*)
 * Rueckgabe: Checksummen-Struct
 */
extern void * SML3_cksum_init(int);


/** SML3_cksum_hmac_init [thread-sicher]:
 * HMAC-Checksummen-Berechnung: Initialisierung
 * 1.Arg: Checksummen-Digest (SML3_CKSUM_DIGEST_*) ohne: SML3_CKSUM_DIGEST_MD5, SML3_CKSUM_DIGEST_HORNER*
 * Rueckgabe: Checksummen-Struct
 *
 * Weitere Operationen finden mit SML3_cksum_add() und SML3_cksum_result() statt
 */
extern void * SML3_cksum_hmac_init(int, const char *, size_t);


/** SML3_cksum_add [thread-sicher]:
 * Checksummen-Berechnung: Daten hinzufuegen
 * 1.Arg: Checksummen-Struct
 * 2.Arg: hinzuzufuegende Daten
 * 3.Arg: Anzahl Bytes im 2.Arg
 */
extern void SML3_cksum_add(void *, const void *, size_t);


/** SML3_cksum_result [thread-sicher]:
 * Checksummen-Berechnung: Ergebnis erhalten,
 *                         1.Arg wird freigegeben,
 *                         braucht SML3_cksum_init() vor weiterer Verwendung
 * 1.Arg: Checksummen-Struct
 * 2.+3.Arg: fuer Rueckgabe Ergebnis
 * Rueckgabe: Pointer auf 2.Arg
 */
extern char * SML3_cksum_result(void *, char *, size_t);

#endif /* SML3__CKSUM_H */
