/* Copyright 2022-2026 Kurt Nienhaus
 *
 * This file is part of VgaGames.
 * VgaGames is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * VgaGames is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with VgaGames.  If not, see <http://www.gnu.org/licenses/>.
 */

/* Aufruf: vgag-mp3 [--8bit] {--mono|--stereo} -r <freq> -q -s <MP3-Datei> */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>

extern int start_mp3(int, char **);

char pgdir[256];


int main(int argc, char **argv) {
  char *pgnam;

  pgnam = strrchr(argv[0], '/');
  if (pgnam == NULL) { fprintf(stderr, "vgag-mp3: cannot determine my directory\n"); exit(1); }
  pgnam++;
  snprintf(pgdir, sizeof(pgdir), "%.*s", (int)(pgnam - argv[0]), argv[0]);

  return start_mp3(argc, argv);
}
