#!/bin/sh

PATH="$PATH:/usr/local/bin"
test "$CC" = "" && CC="cc"

echo >config.status

sdl_version=""
sdl_cflags=""
sdl_libs=""

cfscript=`which pkgconf`
test "$cfscript" = "" && cfscript=`which pkg-config`
if test "$cfscript" != ""
then
  sdl_version="`$cfscript --modversion sdl3 2>/dev/null`"
  sdl_cflags="`$cfscript --cflags sdl3 2>/dev/null`"
  sdl_libs="`$cfscript --libs sdl3 2>/dev/null`"
else
  cfscript=`which sdl3-config`
  if test "$cfscript" != ""
  then
    sdl_version="`$cfscript --version`"
    sdl_cflags="`$cfscript --cflags`"
    sdl_libs="`$cfscript --libs`"
  fi
fi
test "$cfscript" = "" && { echo '!!! SDL3: Did not found pkgconf or pkg-config !!!' >&2; exit 0; }
test "$sdl_version" = "" && exit 0

version_maior=`echo $sdl_version | cut -s -d. -f1`
version_minor=`echo $sdl_version | cut -s -d. -f2`
version_patch=`echo $sdl_version | cut -s -d. -f3`
test "$version_maior" = "" || test "$version_minor" = "" || test "$version_patch" = "" && exit 0
test $version_maior -ne 3 || test $version_minor -lt 2 && exit 0

testfile="/tmp/vg4t"
{ echo "#include <SDL3/SDL.h>"; echo "int main(void) {SDL_Init(SDL_INIT_VIDEO);}"; } >${testfile}.c
$CC ${testfile}.c $sdl_cflags $sdl_libs -o $testfile 2>/dev/null
sdllib=`ldd $testfile | grep "libSDL3" | head -n1 | sed -e 's/.*=> *//' -e 's#\([^ ]*\).*#\1#'`
rm -f ${testfile}.c $testfile
test "x$sdllib" = "x" && exit 0
tag=`basename \`pwd\``

# Output
{ echo "TAG=$tag";
  echo "VERSION=$sdl_version";
  echo "CFLAGS=$sdl_cflags";
  echo "LIB=$sdllib";
} >config.status

exit 0
