#!/bin/sh
# (https://xiph.org/flac/)

parm="$1"
test "$parm" = "" && { echo "FLAC: parameter missing" >&2; exit 1; }

if test "$1" = "-h" || test "$1" = "--help"
then
  echo "(Un)Compiles libFLAC; called from Makefile"
  exit 1
fi

LIBVZ="libflac"
test "$MAKE" = "" && MAKE="make"

retw=0
if test "$parm" = "all"
then
  test -h $LIBVZ && exit 0

  test "$PREFIX" = "" && { echo "FLAC: PREFIX missing" >&2; exit 1; }

  tgzfile=`ls flac-*.tar.gz`
  test "$tgzfile" = "" && exit 1

  tar pxzf "$tgzfile"
  flacvz=""
  for vz in flac-*
  do
    test -d $vz && flacvz=$vz
  done
  test "$flacvz" = "" && exit 1
  rm -f $LIBVZ
  ln -s $flacvz $LIBVZ

  cd $LIBVZ || exit 1

  unset CFLAGS
  unset MAKEFLAGS
  LDFLAGS="-L/usr/local/lib"
  export LDFLAGS
  ./configure --prefix=$PREFIX --disable-cpplibs --disable-ogg --disable-oggtest --disable-doxygen-docs --disable-programs --disable-examples --enable-shared=no
  test $? -eq 0 && $MAKE all install
  retw=$?

elif test "$parm" = "clean"
then
  vz=""
  test -h $LIBVZ && vz=`readlink $LIBVZ`
  if test "$vz" != ""
  then
    rm -rf $vz
    rm -f $LIBVZ
  fi
fi

exit $retw
