#!/bin/sh
# config.sh for external libraries

IOLIB_SCRIPT="iolib-script"

cd `dirname $0` || exit 1

ARG1="$1"

test "x$PREFIX" = "x" && { echo "PREFIX is unset" >&2; exit 1; }
export PREFIX
export CC
export MAKE

EXTRALIBS=""

if test "$ARG1" = ""
then
  # PREFIX is installation-path
  # configure sml3/
  cd sml3 || exit 1
  ./config.sh --prefix="$PREFIX"
  test -f "sml3-config" || { echo "SML3: config-error" >&2; exit 1; }
  cd ..
  # configure iolib/  (for each supported library there must be at least a <library>/config.sh and <library>/make.sh[clean])
  cd iolib || exit 1
  for vz in `ls`
  do
    echo "$ENV_DISABLE_LIBS" | grep "$vz" >/dev/null || (cd $vz && ./config.sh)
  done
  cd ..

elif test "$ARG1" = "make"
then
  # PREFIX is tempinstall-path
  if test "`./$IOLIB_SCRIPT --list`" = ""
  then
    (cd iolib/SDL2 || exit 1
     ./make.sh all || exit 1
     io_version=`$PREFIX/bin/sdl2-config --version`
     io_cflags=`$PREFIX/bin/sdl2-config --cflags`
     test "x$io_version" = "x" && { echo "SDL2: version unknown" >&2; exit 1; }
     { echo "TAG=SDL2";
       echo "VERSION=$io_version";
       echo "CFLAGS=$io_cflags";
       echo "LIB=";
     } >config.status
    ) || exit 1
  else
    exit 0
  fi

elif test "$ARG1" = "install"
then
  # PREFIX is tempinstall-path
  if test "`./$IOLIB_SCRIPT SDL2`" != ""
  then
    io_lib="`./$IOLIB_SCRIPT SDL2 --lib`"
    test "x$io_lib" = "x" && echo "$PREFIX/lib/libSDL2.so"
  fi
  exit 0
fi

EXTRALIBS=`./sml3/sml3-config --extralibs`


# create $IOLIB_SCRIPT

rm -f $IOLIB_SCRIPT

cat << EOF >>$IOLIB_SCRIPT
#!/bin/sh

EXTRALIBS="$EXTRALIBS"

EOF

cat << 'EOF' >>$IOLIB_SCRIPT
ARG0=`basename $0`
PARAM="$1"
test "x$PARAM" = "x" && { echo "$ARG0: no parameter" >&2; exit 1; }
COMD="$2"

EOF

tags=""
deftags=""
for cf in `ls iolib/*/config.status 2>/dev/null`
do
  tag=`grep "TAG=" $cf | cut -d= -f2-`
  if test "x$tag" != "x"
  then
    tags="$tags $tag"
    deftags="$deftags -DIOLIB_LIB_$tag"
    io_version="`grep 'VERSION=' $cf | cut -d= -f2-`"
    io_cflags="`grep 'CFLAGS=' $cf | cut -d= -f2-`"
    io_lib="`grep 'LIB=' $cf | cut -d= -f2-`"
cat << EOF >>$IOLIB_SCRIPT
if test "x\$PARAM" = "x$tag"
then
  test "x\$COMD" = "x" && echo "$tag"
  test "x\$COMD" = "x--version" && echo "$io_version"
  test "x\$COMD" = "x--cflags" && echo "$io_cflags"
  test "x\$COMD" = "x--lib" && echo "$io_lib"
fi

EOF
  fi
done

cat << EOF >>$IOLIB_SCRIPT
if test "x\$PARAM" = "x--list"
then
  echo "$tags"
fi

if test "x\$PARAM" = "x--defines"
then
  echo "$deftags"
fi

if test "x\$PARAM" = "x--extralibs"
then
  echo "\$EXTRALIBS"
fi

exit 0
EOF

chmod 755 $IOLIB_SCRIPT

if test "$ARG1" = ""
then
  # Info
  found=""
  tags="`./$IOLIB_SCRIPT --list`"
  if test "$tags" != ""
  then
    for tag in $tags
    do
      found="$found $tag:`./$IOLIB_SCRIPT $tag --version`"
    done
    echo "IO-Libraries found: $found"
  else
    echo '!!! For compiling SDL2-library there must be installed'
    echo '!!! - GNU-make'
    echo '!!! - libasound2-dev or alsa-devel'
    echo '!!! - libx11-dev or libX11-devel'
    echo '!!! - libxext-dev or libXext-devel'
    echo '!!! - optionally: libpulse-dev or libpulse-devel'
  fi
  echo
fi

exit 0
