#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>


int
main(int argc, char **argv)
{
  static char *vg_no_info = "VG_NO_INFO=1";
  int i1, svport, mbport;
  char *argv0, *cmd;

  if ((argv0 = strrchr(argv[0], '/')) == NULL) { argv0 = argv[0]; } else { argv0++; }

  putenv(vg_no_info);
  if (!VG_init("vg4_nw_server")) { exit(1); }

  if (argc < 2 || strcmp(argv[1], "-h") == 0 || strcmp(argv[1], "--help") == 0)  { goto help_nwserver; }

  opterr = opterr ? opterr : 1;

  cmd = NULL;
  svport = mbport = 0;

  while ((i1 = getopt(argc, argv, "+s:b:")) != -1) {
    switch(i1) {
      case 's': svport = atoi(optarg); break;
      case 'b': mbport = atoi(optarg); break;
      default:  goto help_nwserver;
    }
  }
  if (optind >= argc) { goto help_nwserver; }
  cmd = argv[optind];

  vg4->nw->set_ports(svport, mbport);

  vg4->nw->server(cmd);

  VG_dest();
  exit(0);

help_nwserver:
  VG_dest();
  fprintf(stderr, "Usage: %s [<options>] <command>\n", argv0);
  fprintf(stderr, "Act with the network-server\n");
  fprintf(stderr, "Options:\n");
  fprintf(stderr, " -s <string>: (optional:) network-server UDP-port\n");
  fprintf(stderr, " -b <string>: (optional:) multicast-/broadcast-server UDP-port\n");
  fprintf(stderr, "Commands:\n");
  fprintf(stderr, "  start:    start server\n");
  fprintf(stderr, "  stop:     stop server (needs no UDP-port options)\n");
  fprintf(stderr, "  restart:  restart server\n");
  fprintf(stderr, "  status:   show whether server is running or stopped (needs no UDP-port options)\n");
  fprintf(stderr, "Logging goes to syslog.\n");

  exit(1);
} /* Ende main */
