#!/bin/sh

# library version (to be modified also in doc/man/index.html)
VGAG_VERSION="4.0p1"  # <maior>.<minor>[p<patch>]

VGAG_MAIOR=`echo $VGAG_VERSION | cut -d. -f1`

# source directory
SRCDIR="src"
cwd=`pwd`
pgn=`basename $0`
test -f "$cwd/$pgn" || { echo "Please call $pgn from its directory" >&2; exit 1; }
SOURCE_DIR="$cwd/$SRCDIR"
test -d "$SOURCE_DIR" || { echo "Cannot find source directory" >&2; exit 1; }

# PREFIX: installation prefix
test "$PREFIX" = "" && PREFIX="/usr/local"
# CC: compiler
test "$CC" = "" && CC="cc"

if test "$1" = "-h" || test "$1" = "--help"
then
  echo
  echo "Usage: $0 [<Options>]"
  echo "Following environment variables may be defined:"
  echo " - CC: compiler (default: cc)"
  echo " - PREFIX: installation prefix (default: /usr/local)"
  echo " - MAKE: GNU-Make (default: search for gmake)"
  echo " - PKG_CONFIG_PATH: directories to add to pkg-config's search path"
  echo "Writes Makefile from Makefile.template."
  echo
  echo "Options:"
  echo "  --prefix=PREFIX  install files in PREFIX (default: $PREFIX)"
  echo "                   (overwrites environment variable PREFIX)"
  echo "  --disable-flac   don't compile support for flac"
  echo "  --disable-mp3    don't compile support for mp3"
  echo "  --disable-ogg    don't compile support for ogg/vorbis"
  echo "  --disable-midi   don't compile support for midi"
  echo "  --disable-sdl2   don't compile support for libSDL2"
  echo "  --disable-sdl3   don't compile support for libSDL3"
  echo
  exit 1
fi

# check options
ENV_DISABLE_LIBS=""
export ENV_DISABLE_LIBS
while test $# -gt 0
do
  p1=`echo "$1" | cut -d= -f1`
  p2=`echo "$1" | cut -d= -s -f2`
  test "x$p1" = "x--prefix" && test "$p2" != "" && PREFIX="$p2"
  test "x$p1" = "x--disable-flac" && opt_disable_flac=1
  test "x$p1" = "x--disable-mp3" && opt_disable_mp3=1
  test "x$p1" = "x--disable-ogg" && opt_disable_ogg=1
  test "x$p1" = "x--disable-midi" && opt_disable_midi=1
  test "x$p1" = "x--disable-sdl2" && ENV_DISABLE_LIBS="$ENV_DISABLE_LIBS SDL2"
  test "x$p1" = "x--disable-sdl3" && ENV_DISABLE_LIBS="$ENV_DISABLE_LIBS SDL3"
  shift
done

if test "$CC" = "cc"
then
  osn=`uname -s`
  if test "$osn" = "FreeBSD"
  then
    clang 2>/dev/null
    test $? -ne 127 && CC="clang"
  fi
fi

# check for GNU-Make for extlib compiling
test "$MAKE" = "" && MAKE="gmake"
which $MAKE >/dev/null 2>&1 || MAKE="make"
$MAKE --version 2>/dev/null | fgrep "GNU Make" >/dev/null || { echo "*** GNU Make not found" >&2; exit 1; }

export PREFIX
export CC
export MAKE
export PKG_CONFIG_PATH

# output disable-options and call config.sh from $SRCDIR/extlib/
{ echo "#ifndef OPT_DISABLE_H_"; echo "#define OPT_DISABLE_H_"; } > $SRCDIR/vglib/opt_disable.h
cpath="./$SRCDIR/extlib"
test "$opt_disable_flac" = "1" && { echo "# define VGI_DISABLE_FLAC" >> $SRCDIR/vglib/opt_disable.h; echo > $cpath/disable.flac; }
test "$opt_disable_mp3" = "1" && { echo "# define VGI_DISABLE_MP3" >> $SRCDIR/vglib/opt_disable.h; echo > $cpath/disable.mp3; }
test "$opt_disable_ogg" = "1" && { echo "# define VGI_DISABLE_OGG" >> $SRCDIR/vglib/opt_disable.h; echo > $cpath/disable.ogg; }
test "$opt_disable_midi" = "1" && { echo "# define VGI_DISABLE_MIDI" >> $SRCDIR/vglib/opt_disable.h; echo > $cpath/disable.midi; }
echo "#endif" >> $SRCDIR/vglib/opt_disable.h
echo -n > $cpath/ext.libs
(cd $cpath && ./config.sh) || exit 1

echo "Using for make: $MAKE"
echo

# create vgagames header file
echo "Creating vglib/vgagames$VGAG_MAIOR.h ..."
cat $SRCDIR/vglib/vgagames$VGAG_MAIOR.h.template \
  | sed -e "s%##VGAG_VERSION##%#define VGAG_VERSION \"$VGAG_VERSION\"%" \
  | sed -e "s%##VGAG_PREFIX##%#define VGAG_PREFIX \"$PREFIX\"%" \
  > $SRCDIR/vglib/vgagames$VGAG_MAIOR.h

# create Makefile
echo "Creating Makefile ..."
cat $SRCDIR/Makefile.template \
  | sed -e "s%##SOURCE_DIR##%SOURCE_DIR = $SOURCE_DIR%" \
  | sed -e "s%##MAKE##%MAKE = $MAKE%" \
  | sed -e "s%##PREFIX##%PREFIX = $PREFIX%" \
  | sed -e "s%##CC##%CC = $CC%" \
  | sed -e "s%##VGAG_VERSION##%VGAG_VERSION = $VGAG_VERSION%" \
  | sed -e "s%##VGAG_MAIOR##%VGAG_MAIOR = $VGAG_MAIOR%" \
  > $SRCDIR/Makefile

# create Config-Script
echo "Creating Config-Script ..."
cat $SRCDIR/vgagames$VGAG_MAIOR-config.template \
  | sed -e "s%##VGAG_VERSION##%VGAG_VERSION=\"$VGAG_VERSION\"%" \
  | sed -e "s%##VGAG_PREFIX##%VGAG_PREFIX=\"$PREFIX\"%" \
  > $SRCDIR/vgagames$VGAG_MAIOR-config

# info
echo
echo "To continue, call: make all install"
echo "Or get help with: make help"

exit 0
