/* show a film */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>


int main(int argc, char **argv) {
  struct VG_Rect rect;
  VG_BOOL filmskip;

  (void)argc; (void)argv;

  /* initialize and open window and audio */
  if (!VG_init("test")) { exit(1); }
  if (!vg4->window->open(VG_WINDOW_SIZE_LOW, VG_WINDOW_SCALE_BEST)) { VG_dest(); exit(1); }
  if (!vg4->audio->open(VG_AUDIO_FREQ_MEDIUM, VG_FALSE)) { VG_dest(); exit(1); }

  /* add multilanguage files */
  vg4->mlang->fb_locale("en");
  vg4->mlang->add("mlang");

  vg4->window->fill(VG_COLOR_BLUE);

  /* play film in a centered rectangle, allow skipping */
  rect.x = 30; rect.w = 260;
  rect.y = 20; rect.h = 160;
  vg4->film->play("film", &rect, &filmskip, NULL);
  if (filmskip) { printf("Film was skipped\n"); }

  /* destroy and exit */
  VG_dest();
  exit(0);
}
