/* draw information onto window about the state of pressing keys */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>

static void draw_events(VG_BOOL, VG_BOOL, VG_BOOL);

int main(int argc, char **argv) {
  struct {
    int k_left;
    int k_right;
    int k_space;
    int k_quit;
  } kref;
  VG_BOOL is_left, is_right, is_space;

  (void)argc; (void)argv;

  /* initialize and open window */
  if (!VG_init("test")) { exit(1); }
  if (!vg4->window->open(VG_WINDOW_SIZE_LOW, VG_WINDOW_SCALE_BEST)) { VG_dest(); exit(1); }

  /* +++ insert key-entries +++ */

  /* insert key-entry "left" with left cursor key */
  if ((kref.k_left = vg4->input->key_insert("Left", VG_TRUE, VG_FALSE)) == 0) { VG_dest(); exit(1); } 
  vg4->input->key_setkbd(kref.k_left, VG_INPUT_KBDCODE_LCURS);

  /* insert key-entry "right" with right cursor key */
  if ((kref.k_right = vg4->input->key_insert("Right", VG_TRUE, VG_FALSE)) == 0) { VG_dest(); exit(1); } 
  vg4->input->key_setkbd(kref.k_right, VG_INPUT_KBDCODE_RCURS);

  /* insert key-entry "space" with spacebar */
  if ((kref.k_space = vg4->input->key_insert("Space", VG_TRUE, VG_FALSE)) == 0) { VG_dest(); exit(1); } 
  vg4->input->key_setkbd(kref.k_space, VG_INPUT_KBDCODE_SPACE);

  /* insert key-entry "quit" with key "Q" */
  if ((kref.k_quit = vg4->input->key_insert("Quit", VG_TRUE, VG_FALSE)) == 0) { VG_dest(); exit(1); } 
  vg4->input->key_setkbd(kref.k_quit, VG_INPUT_KBDCODE_Q);

  /* +++ game loop +++ */

  for (;;) {
    /* retrieve input-events */
    if (!vg4->input->update(VG_TRUE)) { break; }

    /* check for quitting */
    if (vg4->input->key_newpressed(kref.k_quit)) { break; }

    /* check for key events */
    is_left = is_right = is_space = VG_FALSE;
    if (vg4->input->key_pressed(kref.k_left)) { is_left = VG_TRUE; }
    if (vg4->input->key_pressed(kref.k_right)) { is_right = VG_TRUE; }
    if (vg4->input->key_pressed(kref.k_space)) { is_space = VG_TRUE; }

    /* write out information about pressed keys */
    vg4->window->clear();
    draw_events(is_left, is_right, is_space);
    vg4->window->flush();

    vg4->misc->wait_time(50);
  }

  /* destroy and exit */
  VG_dest();
  exit(0);
}


/* write out information about pressed keys */
static void
draw_events(VG_BOOL is_left, VG_BOOL is_right, VG_BOOL is_space)
{
  char buf[128];
  struct VG_Image *imgp;

  snprintf(buf, sizeof(buf),
           "LEFT is %spressed\nRIGHT is %spressed\nSPACE is %spressed\n\nExit with Q",
           (is_left ? "" : "not "),
           (is_right ? "" : "not "),
           (is_space ? "" : "not "));

  imgp = vg4->font->totext(buf, NULL, NULL, NULL, NULL);
  if (imgp != NULL) {
    vg4->window->copy(imgp, NULL, NULL);
    vg4->image->destroy(imgp);
  }
}
