/* object-collision "RECTANGLE1" against "RECTANGLE2" (and inverse) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-rectangle1.h"
#include "obj-rectangle2.h"

int objcoll_RECTANGLE1_RECTANGLE2(void *, unsigned int, struct VG_Coll *);

int
objcoll_RECTANGLE1_RECTANGLE2(void *vgame, unsigned int instanceid, struct VG_Coll *collb)
{
  struct VG_Object *objp_moving, *objp_hit;
  struct sobj_rectangle1 *objvars_rectangle1;
  struct sobj_rectangle2 *objvars_rectangle2;
  int retw = VG_COLL_RETURN_CONTINUE;

  (void)vgame;

  /* get object-instances */
  objp_moving = vg4->object->instance_getobj(instanceid);
  objp_hit = vg4->object->instance_getobj(collb->instanceid);

  if (strcmp(objp_moving->objid, "RECTANGLE1") == 0) {
    /* RECTANGLE1 is moving, hitting RECTANGLE2 */
    objvars_rectangle1 = (struct sobj_rectangle1 *)objp_moving->opriv;
    objvars_rectangle2 = (struct sobj_rectangle2 *)objp_hit->opriv;
  } else {
    /* RECTANGLE2 is moving, hitting RECTANGLE1 (here impossible as rectangle2 is not moving) */
    objvars_rectangle1 = (struct sobj_rectangle1 *)objp_hit->opriv;
    objvars_rectangle2 = (struct sobj_rectangle2 *)objp_moving->opriv;
  }

  /* modify colors */
  if (collb->type == VG_COLL_TYPE_ENTRY) {  /* entering into collision */
    /* change colors to yellow and white */
    objvars_rectangle1->color = VG_COLOR_YELLOW;
    objvars_rectangle2->color = VG_COLOR_WHITE;
  } else if (collb->type == VG_COLL_TYPE_LEAVE) {  /* leaving collision */
    /* reset colors to default */
    objvars_rectangle1->color = VG_COLOR_RED;
    objvars_rectangle2->color = VG_COLOR_GREEN;
  }

  return retw;
}
