/* object "RECTANGLE2" */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-rectangle2.h"

#define OBJID "RECTANGLE2"

unsigned int objnew_RECTANGLE2(void *);

static void f_free(void *, void *);
static void f_draw(void *, struct VG_Object *);


/* export-function to create a new object-instance of "RECTANGLE2" */
unsigned int
objnew_RECTANGLE2(void *vgame)
{
  const int coll_percent = 100;
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_rectangle2 *objvars;
  int winw, winh;

  if (sgame == NULL) { return 0; }

  vg4->window->getsize(&winw, &winh);

  /* allocate private struct */
  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  /* set private struct */
  objvars->rect.x = winw / 2;
  objvars->rect.w = 20;
  objvars->rect.y = winh / 2;
  objvars->rect.h = 20;
  objvars->color = VG_COLOR_GREEN;

  /* create object-instance */
  objp = vg4->object->create(OBJID, 0, 0, 1, objvars);

  /* set functions */
  objp->f_free = f_free;
  objp->f_draw = f_draw;
  /* f_run(), f_data() and f_childexit() are not needed here */

  /* insert object-instance into collision-tag */
  vg4->collision->insert(sgame->coll_tag, objp->instanceid, &objvars->rect, coll_percent);

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct sobj_rectangle2 *objvars = (struct sobj_rectangle2 *)opriv;

  (void)vgame;

  /* free private struct */
  free(objvars);
}


/* draw object-instance, called from vg4->object->call_draw() */
static void
f_draw(void *vgame, struct VG_Object *objp)
{
  struct sobj_rectangle2 *objvars = (struct sobj_rectangle2 *)objp->opriv;

  (void)vgame;

  /* draw it */
  vg4->window->draw_rect(&objvars->rect, objvars->color, VG_TRUE);
}
