/* object "RECTANGLE1" */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-rectangle1.h"

#define OBJID "RECTANGLE1"

unsigned int objnew_RECTANGLE1(void *);

static void f_free(void *, void *);
static VG_BOOL f_run(void *, struct VG_Object *);
static void f_draw(void *, struct VG_Object *);


/* export-function to create a new object-instance of "RECTANGLE1" */
unsigned int
objnew_RECTANGLE1(void *vgame)
{
  const int coll_percent = 100;
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_rectangle1 *objvars;
  int winw, winh;

  if (sgame == NULL) { return 0; }

  vg4->window->getsize(&winw, &winh);

  /* allocate private struct */
  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  /* set private struct */
  objvars->rect.x = 0;
  objvars->rect.w = 20;
  objvars->rect.y = winh / 2 - 5;
  objvars->rect.h = 20;
  objvars->color = VG_COLOR_RED;

  /* create object-instance */
  objp = vg4->object->create(OBJID, 0, 0, 1, objvars);

  /* set functions */
  objp->f_free = f_free;
  objp->f_run = f_run;
  objp->f_draw = f_draw;
  /* f_data() and f_childexit() are not needed here */

  /* insert object-instance into collision-tag */
  vg4->collision->insert(sgame->coll_tag, objp->instanceid, &objvars->rect, coll_percent);

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct sobj_rectangle1 *objvars = (struct sobj_rectangle1 *)opriv;

  (void)vgame;

  /* free private struct */
  free(objvars);
}


/* move object-instance, called from vg4->object->call_run() */
static VG_BOOL
f_run(void *vgame, struct VG_Object *objp)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_rectangle1 *objvars = (struct sobj_rectangle1 *)objp->opriv;
  int winw, canz, cret;
  struct VG_Coll *collp;

  /* move it one step to the right until window-boundary */
  vg4->window->getsize(&winw, NULL);
  if (++objvars->rect.x == winw) { return VG_FALSE; }  /* window-boundary: end of game */

  /* update object-instance in collision-tag and check for collisions */
  canz = vg4->collision->setpos(sgame->coll_tag, objp->instanceid, &objvars->rect, &collp);

  /* call collision-functions and free collision array */
  cret = vg4->object->collision_call(sgame, objp->instanceid, collp, canz);
  if (collp != NULL) { free(collp); }

  if (cret == VG_COLL_RETURN_STOP || cret == VG_COLL_RETURN_STOP_X || cret == VG_COLL_RETURN_STOP_Y) {
    /* if stopped, go back and update object-instance in collision-tag */
    objvars->rect.x--;
    vg4->collision->setpos(sgame->coll_tag, objp->instanceid, &objvars->rect, NULL);
  } else if (cret == VG_COLL_RETURN_DEAD) {
    /* if dead, destroy yourself and return */
    vg4->object->destroy(sgame, objp->instanceid);
    return VG_TRUE;
  }

  return VG_TRUE;
}


/* draw object-instance, called from vg4->object->call_draw() */
static void
f_draw(void *vgame, struct VG_Object *objp)
{
  struct sobj_rectangle1 *objvars = (struct sobj_rectangle1 *)objp->opriv;

  (void)vgame;

  /* draw it */
  vg4->window->draw_rect(&objvars->rect, objvars->color, VG_TRUE);
}
