/* move an object-instance to another, change colors of both while they collide */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "example.h"

/* private structure of the game */
struct s_game sgame;


int main(int argc, char **argv) {
  (void)argc; (void)argv;

  /* initialize and open window */
  if (!VG_init("test")) { exit(1); }
  if (!vg4->window->open(VG_WINDOW_SIZE_LOW, VG_WINDOW_SCALE_BEST)) { VG_dest(); exit(1); }

  /* add object-collision functions */
  vg4->object->collision_add("RECTANGLE1", "RECTANGLE2", objcoll_RECTANGLE1_RECTANGLE2);

  /* initialize game-structure */
  memset(&sgame, 0, sizeof(sgame));

  /* create collision-tag */
  sgame.coll_tag = vg4->collision->create(NULL, 0, 0);

  /* create object-instances */
  if (objnew_RECTANGLE1(&sgame) == 0) { VG_dest(); exit(1); }
  if (objnew_RECTANGLE2(&sgame) == 0) { VG_dest(); exit(1); }

  /* game loop */
  for (;;) {
    if (!vg4->input->update(VG_TRUE)) { break; }

    vg4->window->clear();

    /* call f_run() of all object-instances */
    if (!vg4->object->call_run(&sgame)) { break; }

    /* call f_draw() of all object-instances */
    vg4->object->call_draw(&sgame);

    vg4->window->flush();
    vg4->misc->wait_time(30);
  }

  /* destroy and exit */
  VG_dest();
  exit(0);
}
