/* create an image, draw figures into it and show it */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>

int main(int argc, char **argv) {
  struct VG_Image *imgp;
  int imgw, imgh, radius;
  struct VG_Rect rect;

  (void)argc; (void)argv;

  /* initialize and open window */
  if (!VG_init("test")) { exit(1); }
  if (!vg4->window->open(VG_WINDOW_SIZE_LOW, VG_WINDOW_SCALE_NONE)) { VG_dest(); exit(1); }

  /* create image */
  imgw = imgh = 100;
  imgp = vg4->image->create(imgw, imgh);

  /* fill image with grey color */
  vg4->image->fill(imgp, VG_COLOR_RGB(64, 64, 64));

  /* draw a filled circle */
  radius = 40;
  vg4->image->draw_circle(imgp, imgw / 2, imgh / 2, radius, VG_COLOR_YELLOW, VG_TRUE);

  /* draw a rectangle around the circle */
  rect.x = imgw / 2 - radius;
  rect.w = radius * 2 + 1;
  rect.y = imgh / 2 - radius;
  rect.h = radius * 2 + 1;
  vg4->image->draw_rect(imgp, &rect, VG_COLOR_RED, VG_FALSE);

  /* draw two lines */
  vg4->image->draw_line(imgp, 0, 0, imgw - 1, imgh - 1, VG_COLOR_TURQUOISE);
  vg4->image->draw_line(imgp, imgw - 1, 0, 0, imgh - 1, VG_COLOR_TURQUOISE);

  /* copy image to window */
  vg4->window->copy(imgp, NULL, NULL);
  vg4->window->flush();

  sleep(5);

  /* destroy and exit */
  VG_dest();
  exit(0);
}
