/* load textfile and show it */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>

int main(int argc, char **argv) {
  struct VG_Image *imgp;

  (void)argc; (void)argv;

  /* initialize and open window */
  if (!VG_init("test")) { exit(1); }
  if (!vg4->window->open(VG_WINDOW_SIZE_LOW, VG_WINDOW_SCALE_NONE)) { VG_dest(); exit(1); }

  /* create image from text */
  imgp = vg4->font->loadtext("textfile", "[bgcolor=0x888888]", NULL, NULL);
  if (imgp == NULL) { VG_dest(); exit(1); }

  /* show text-image */
  vg4->window->copy(imgp, NULL, NULL);
  vg4->window->flush();
  sleep(5);

  vg4->image->destroy(imgp);

  /* destroy and exit */
  VG_dest();
  exit(0);
}
