/* load a sprite, show it until it ends */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>

int main(int argc, char **argv) {
  struct VG_Sprite *sprt;
  struct VG_Image *imgp;
  struct VG_ImagecopyAttr iattr;

  (void)argc; (void)argv;

  /* initialize and open window */
  if (!VG_init("test")) { exit(1); }
  if (!vg4->window->open(VG_WINDOW_SIZE_LOW, VG_WINDOW_SCALE_NONE)) { VG_dest(); exit(1); }

  /* load sprite */
  sprt = vg4->sprite->load("boy.sprite");
  if (sprt == NULL) { VG_dest(); exit(1); }

  for (;;) {
    /* get next sprite-element, check for ending sprite */
    if (!vg4->sprite->next(sprt, &imgp, &iattr)) { break; }

    /* copy image to window, if an image was returned */
    vg4->window->clear();
    if (imgp != NULL) {
      vg4->window->copy(imgp, NULL, &iattr);
    }

    vg4->window->flush();
    vg4->misc->wait_time(50);
  }

  vg4->sprite->destroy(sprt);

  /* destroy and exit */
  VG_dest();
  exit(0);
}
