/* select a sunnyboy from a list or a chain */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>


/* show sub-canvas containing information of selected sunnyboy */
static void
show_subcanvas(struct VG_Canvas *cvas_top, const char *selected_sb)
{
  struct VG_Canvas *cvas_sub;
  struct VG_Hash *hvar;
  struct VG_Position possub;
  struct VG_ImagecopyAttrPixel iattr_pixel;
  const char *selname;

  /* set variables */
  hvar = vg4->hash->create();
  vg4->hash->setstr(hvar, "sb_color", selected_sb);

  /* load canvas with variables */
  cvas_sub = vg4->canvas->load("example-sub.cvas", hvar);
  vg4->hash->destroy(hvar);
  if (cvas_sub == NULL) { return; }

  /* get position of sub-canvas and set background with reduced brightness */
  VG_IMAGECOPY_ATTRPIXEL_DEFAULT(&iattr_pixel);
  iattr_pixel.brightness = 60;
  possub = vg4->canvas->subcanvas(cvas_top, &iattr_pixel);

  /* execute sub-canvas */
  if (!vg4->canvas->exec(cvas_sub, &possub, &selname)) { return; }

  /* as there is just an OK-button, the selection is ignored */
}


int main(int argc, char **argv) {
  struct VG_Canvas *cvas_top;
  const char *selname;
  const char *selected_sb;

  (void)argc; (void)argv;

  /* initialize and open window */
  if (!VG_init("test")) { exit(1); }
  if (!vg4->window->open(VG_WINDOW_SIZE_LOW, VG_WINDOW_SCALE_BEST)) { VG_dest(); exit(1); }

  /* load canvas */
  cvas_top = vg4->canvas->load("example-top.cvas", NULL);
  if (cvas_top == NULL) { VG_dest(); exit(1); }

  /* fill selection-list */
  vg4->canvas->list_add(cvas_top, "sb_list", "Red sunnyboy", "sb_red");
  vg4->canvas->list_add(cvas_top, "sb_list", "Yellow sunnyboy", "sb_yellow");
  vg4->canvas->list_add(cvas_top, "sb_list", "Blue sunnyboy", "sb_blue");

  /* set switch to ON and disable selection-chain */
  vg4->canvas->switch_set(cvas_top, "list_or_chain", VG_TRUE);
  vg4->canvas->disable(cvas_top, "sb_chain", VG_TRUE);

  /* contains the color of the selected sunnyboy */
  selected_sb = NULL;

  for (;;) {
    /* execute canvas */
    if (!vg4->canvas->exec(cvas_top, NULL, &selname)) { VG_dest(); exit(1); }
    if (selname == NULL) { break; }  /* cancelled via escape-key or cancel-button */

    /* act according to selection */

    if (*selname == '\0') {  /* no selection, but return-key pressed */
      /* no action, re-execute canvas */
      ;

    } else if (strcmp(selname, "list_or_chain") == 0) {  /* switch selected */
      /* enable or disable list and chain according to switch */
      VG_BOOL is_on = vg4->canvas->switch_get(cvas_top, selname);
      if (is_on) {
        vg4->canvas->disable(cvas_top, "sb_list", VG_FALSE);
        vg4->canvas->disable(cvas_top, "sb_chain", VG_TRUE);
      } else {
        vg4->canvas->disable(cvas_top, "sb_list", VG_TRUE);
        vg4->canvas->disable(cvas_top, "sb_chain", VG_FALSE);
      }

    } else if (strcmp(selname, "sb_list") == 0) {  /* item selected from list */
      /* set selected_sb to color of selected list-item */
      const char *listkey = vg4->canvas->list_get_activated(cvas_top, selname);
      if (listkey != NULL) {
        if (strcmp(listkey, "sb_red") == 0) { selected_sb = "red"; }
        else if (strcmp(listkey, "sb_yellow") == 0) { selected_sb = "yellow"; }
        else if (strcmp(listkey, "sb_blue") == 0) { selected_sb = "blue"; }
      }

    } else if (strcmp(selname, "sb_chain") == 0) {  /* item selected from chain */
      /* set selected_sb to color of selected chain-item */
      const char *chainkey = vg4->canvas->chain_get_activated(cvas_top, selname);
      if (chainkey != NULL) {
        if (strcmp(chainkey, "sb_red") == 0) { selected_sb = "red"; }
        else if (strcmp(chainkey, "sb_yellow") == 0) { selected_sb = "yellow"; }
        else if (strcmp(chainkey, "sb_blue") == 0) { selected_sb = "blue"; }
      }
    }

    /* if sunnyboy was selected, show sub-canvas and exit */
    if (selected_sb != NULL) {
      show_subcanvas(cvas_top, selected_sb);
      break;
    }
  }

  /* destroy and exit */
  VG_dest();
  exit(0);
}
