/* object-collision "PLAYER" against "BALL" (and inverse) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>
#include "pingpong.h"
#include "obj-player.h"
#include "obj-ball.h"

int objcoll_PLAYER_BALL(void *, unsigned int, struct VG_Coll *);

int
objcoll_PLAYER_BALL(void *vgame, unsigned int instanceid, struct VG_Coll *collb)
{
  struct VG_Object *objp;
  struct sobj_ball *objvars_ball;
  int xdelta, ydelta;
  int retw = VG_COLL_RETURN_CONTINUE;

  (void)vgame;

  /* only entering into collision is interesting here */
  if (collb->type != VG_COLL_TYPE_ENTRY) { return retw; }

  /* act according to moving object-instance */

  objp = vg4->object->instance_getobj(instanceid);

  if (strcmp(objp->objid, "PLAYER") == 0) {
    /* PLAYER is moving, hitting BALL */
    objp = vg4->object->instance_getobj(collb->instanceid);
    objvars_ball = (struct sobj_ball *)objp->opriv;

    /* check collision sides of hit object-instance (ball) */
    if (collb->side & VG_COLL_SIDE_LEFT) {
      /* set new moving-angle of ball */
      vg4->misc->xy_from_angle(objvars_ball->angle, &xdelta, &ydelta);
      xdelta = -xdelta;
      objvars_ball->angle = vg4->misc->angle_from_xy(xdelta, ydelta, NULL);
      retw = VG_COLL_RETURN_STOP;  /* stop moving object-instance (player) */
    }
    if (collb->side & (VG_COLL_SIDE_TOP | VG_COLL_SIDE_BOTTOM)) {
      /* set new moving-angle of ball */
      vg4->misc->xy_from_angle(objvars_ball->angle, &xdelta, &ydelta);
      ydelta = -ydelta;
      objvars_ball->angle = vg4->misc->angle_from_xy(xdelta, ydelta, NULL);
      retw = VG_COLL_RETURN_STOP;  /* stop moving object-instance (player) */
    }

  } else {
    /* BALL is moving, hitting PLAYER */
    objvars_ball = (struct sobj_ball *)objp->opriv;

    /* check collision sides of hit object-instance (player) */
    if (collb->side & VG_COLL_SIDE_RIGHT) {
      /* set new moving-angle of ball */
      vg4->misc->xy_from_angle(objvars_ball->angle, &xdelta, &ydelta);
      xdelta = -xdelta;
      objvars_ball->angle = vg4->misc->angle_from_xy(xdelta, ydelta, NULL);
      retw = VG_COLL_RETURN_STOP;  /* stop moving object-instance (ball) */
    }
    if (collb->side & (VG_COLL_SIDE_TOP | VG_COLL_SIDE_BOTTOM)) {
      /* set new moving-angle of ball */
      vg4->misc->xy_from_angle(objvars_ball->angle, &xdelta, &ydelta);
      ydelta = -ydelta;
      objvars_ball->angle = vg4->misc->angle_from_xy(xdelta, ydelta, NULL);
      retw = VG_COLL_RETURN_STOP;  /* stop moving object-instance (ball) */
    }
  }

  /* play hit-sound if collision */
  if (retw == VG_COLL_RETURN_STOP) { vg4->audio->play(objvars_ball->audc_hit, VG_FALSE, VG_FALSE); }

  return retw;
}
