/* object "PLAYER" */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-player.h"

/* Object-ID */
#define OBJID "PLAYER"

unsigned int objnew_PLAYER(void *);

static void f_free(void *, void *);
static VG_BOOL f_run(void *, struct VG_Object *);
static void f_draw(void *, struct VG_Object *);


/* export-function to create a new object-instance of "PLAYER" */
unsigned int
objnew_PLAYER(void *vgame)
{
  const int coll_percent = 90;
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_player *objvars;

  if (sgame == NULL) { return 0; }

  /* allocate private struct */
  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  /* set private struct */
  objvars->imgp = vg4->image->load("files/player.bmp");
  if (objvars->imgp == NULL) { return 0; }
  vg4->image->getsize(objvars->imgp, NULL, &objvars->rect.w, &objvars->rect.h);
  objvars->rect.x = 0;
  objvars->rect.y = (sgame->winh - objvars->rect.h) / 2;

  /* create object-instance */
  objp = vg4->object->create(OBJID, 0, 0, 2, objvars);

  /* set functions */
  objp->f_free = f_free;
  objp->f_run = f_run;
  objp->f_draw = f_draw;
  /* f_data() and f_childexit() are not needed here */

  /* insert object-instance into collision-tag */
  vg4->collision->insert(sgame->coll_tag, objp->instanceid, &objvars->rect, coll_percent);

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct sobj_player *objvars = (struct sobj_player *)opriv;

  (void)vgame;

  /* free private struct */
  vg4->image->destroy(objvars->imgp);
  free(objvars);
}


/* move object-instance, called from vg4->object->call_run() */
static VG_BOOL
f_run(void *vgame, struct VG_Object *objp)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_player *objvars = (struct sobj_player *)objp->opriv;
  int y_old;

  if (sgame == NULL) { return VG_TRUE; }

  /* +++ check for key-strokes +++ */

  y_old = objvars->rect.y;

  /* moving up */
  if (vg4->input->key_pressed(sgame->kref.k_up)) {
    objvars->rect.y -= 2;
  }

  /* moving down */
  if (vg4->input->key_pressed(sgame->kref.k_down)) {
    objvars->rect.y += 2;
  }

  /* +++ check for collisions if moved +++ */

  if (y_old != objvars->rect.y) {  /* moved */
    int canz, cret;
    struct VG_Coll *collp;

    /* update object-instance in collision-tag and check for collisions */
    canz = vg4->collision->setpos(sgame->coll_tag, objp->instanceid, &objvars->rect, &collp);

    /* call collision-functions and free collision array */
    cret = vg4->object->collision_call(sgame, objp->instanceid, collp, canz);
    if (collp != NULL) { free(collp); }

    /* check return-value */
    if (cret == VG_COLL_RETURN_STOP) {
      /* stopped, go back and update object-instance in collision-tag */
      objvars->rect.y = y_old;
      vg4->collision->setpos(sgame->coll_tag, objp->instanceid, &objvars->rect, NULL);
    }
    /* no other return-values are set in any collision-function here */
  }

  return VG_TRUE;
}


/* draw object-instance, called from vg4->object->call_draw() */
static void
f_draw(void *vgame, struct VG_Object *objp)
{
  struct sobj_player *objvars = (struct sobj_player *)objp->opriv;
  struct VG_Position posi;

  (void)vgame;

  /* draw it */
  vg4->window->copy(objvars->imgp, vg4->misc->rect2position(&posi, &objvars->rect), NULL);
}
