/* object "BORDER" */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-border.h"

/* Object-ID */
#define OBJID "BORDER"

unsigned int objnew_BORDER(void *, const char *);

static void f_free(void *, void *);
static void f_draw(void *, struct VG_Object *);


/* export-function to create a new object-instance of "BORDER" */
unsigned int
objnew_BORDER(void *vgame, const char *cposition)
{
  const int coll_percent = 100;
  const int border_size = 10;  /* size of borders in pixels */
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_border *objvars;

  if (sgame == NULL || cposition == NULL) { return 0; }

  /* allocate private struct */
  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  /* set private struct */
  if (strcmp(cposition, "top") == 0) {
    objvars->rect.x = objvars->rect.y = 0;
    objvars->rect.w = sgame->winw;
    objvars->rect.h = border_size;
  } else if (strcmp(cposition, "bottom") == 0) {
    objvars->rect.x = 0;
    objvars->rect.y = sgame->winh - border_size;
    objvars->rect.w = sgame->winw;
    objvars->rect.h = border_size;
  } else if (strcmp(cposition, "right") == 0) {
    objvars->rect.x = sgame->winw - border_size;
    objvars->rect.y = 0;
    objvars->rect.w = border_size;
    objvars->rect.h = sgame->winh;
  } else {
    free(objvars);
    return 0;
  }
  objvars->imgp = vg4->image->create(objvars->rect.w, objvars->rect.h);
  vg4->image->fill(objvars->imgp, VG_COLOR_RGB(0xb1, 0, 0));

  /* create object-instance */
  objp = vg4->object->create(OBJID, 0, 0, 1, objvars);

  /* set functions */
  objp->f_free = f_free;
  objp->f_draw = f_draw;
  /* f_run(), f_data() and f_childexit() are not needed here */

  /* insert object-instance into collision-tag */
  vg4->collision->insert(sgame->coll_tag, objp->instanceid, &objvars->rect, coll_percent);

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct sobj_border *objvars = (struct sobj_border *)opriv;

  (void)vgame;

  /* free private struct */
  vg4->image->destroy(objvars->imgp);
  free(objvars);
}


/* draw object-instance, called from vg4->object->call_draw() */
static void
f_draw(void *vgame, struct VG_Object *objp)
{
  struct sobj_border *objvars = (struct sobj_border *)objp->opriv;
  struct VG_Position posi;

  (void)vgame;

  /* draw it */
  vg4->window->copy(objvars->imgp, vg4->misc->rect2position(&posi, &objvars->rect), NULL);
}
