/* object "BALL" */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-ball.h"

/* Object-ID */
#define OBJID "BALL"

unsigned int objnew_BALL(void *);

static void f_free(void *, void *);
static VG_BOOL f_run(void *, struct VG_Object *);
static void f_draw(void *, struct VG_Object *);


/* export-function to create a new object-instance of "BALL" */
unsigned int
objnew_BALL(void *vgame)
{
  const int coll_percent = 90;
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_ball *objvars;

  if (sgame == NULL) { return 0; }

  /* allocate private struct */
  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  /* set private struct */
  objvars->imgp = vg4->image->load("files/ball.bmp");
  if (objvars->imgp == NULL) { return 0; }
  vg4->image->getsize(objvars->imgp, NULL, &objvars->rectc.rect.w, &objvars->rectc.rect.h);
  objvars->rectc.rect.x = (sgame->winw - objvars->rectc.rect.w) / 2;
  objvars->rectc.rect.y = (sgame->winh - objvars->rectc.rect.h) / 2;
  objvars->rectc.centx = objvars->rectc.centy = 0;
  objvars->angle = 45 + 90 * vg4->random->get("ball-angle", 0, 3);  /* randomized moving direction */
  objvars->factor = 3500;
  objvars->audc_hit = vg4->audio->load("files/hit.wav", 100, VG_AUDIO_VOLUME_SOUND);

  /* create object-instance */
  objp = vg4->object->create(OBJID, 0, 0, 3, objvars);

  /* set functions */
  objp->f_free = f_free;
  objp->f_run = f_run;
  objp->f_draw = f_draw;
  /* f_data() and f_childexit() are not needed here */

  /* insert object-instance into collision-tag */
  vg4->collision->insert(sgame->coll_tag, objp->instanceid, &objvars->rectc.rect, coll_percent);

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct sobj_ball *objvars = (struct sobj_ball *)opriv;

  (void)vgame;

  /* free private struct */
  vg4->image->destroy(objvars->imgp);
  vg4->audio->unload(objvars->audc_hit);
  free(objvars);
}


/* move object-instance, called from vg4->object->call_run() */
static VG_BOOL
f_run(void *vgame, struct VG_Object *objp)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_ball *objvars = (struct sobj_ball *)objp->opriv;
  struct VG_RectCent *rectcp;
  int rectc_nr;

  if (sgame == NULL) { return VG_TRUE; }

  /* increase ball-factor for 1/1000 pixel */
  objvars->factor++;

  /* get moving steps */
  rectc_nr = vg4->misc->moving_one_step(&objvars->rectc, objvars->angle, objvars->factor / 100, &rectcp);

  /* check for collisions for each rectangle */
  if (!vg4->misc->move_and_check_collisions(vgame, objp->instanceid, &objvars->rectc, sgame->coll_tag, rectcp, rectc_nr)) {
    /* object-instance is dead (shouldn't happen!) */
    if (rectcp != NULL) { free(rectcp); }
    vg4->object->destroy(sgame, objp->instanceid);
    return VG_TRUE; 
  }

  /* free moving steps */
  if (rectcp != NULL) { free(rectcp); }

  /* check if player missed ball */
  if (objvars->rectc.rect.x + objvars->rectc.rect.w <= 0) { return VG_FALSE; }

  return VG_TRUE;
}


/* draw object-instance, called from vg4->object->call_draw() */
static void
f_draw(void *vgame, struct VG_Object *objp)
{
  struct sobj_ball *objvars = (struct sobj_ball *)objp->opriv;
  struct VG_Position posi;

  (void)vgame;

  /* draw it */
  vg4->window->copy(objvars->imgp, vg4->misc->rect2position(&posi, &objvars->rectc.rect), NULL);
}
