/* open window and draw a circle, then again with window properties set to grey color */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>

int main(int argc, char **argv) {
  int winw, winh, radius;
  struct VG_ImagecopyAttrPixel wattr_pixel;

  (void)argc; (void)argv;

  /* initialize VgaGames library */
  if (!VG_init("window-example")) { exit(1); }

  /* open window with low size and best (integer) scaling */
  if (!vg4->window->open(VG_WINDOW_SIZE_LOW, VG_WINDOW_SCALE_BEST)) { VG_dest(); exit(1); }

  /* get (virtual) size of the window */
  vg4->window->getsize(&winw, &winh);

  /* +++ first draw a yellow circle onto a blue background +++ */

  /* clear window and fill it with blue color */
  vg4->window->clear();
  vg4->window->fill(VG_COLOR_BLUE);

  /* draw a yellow filled circle at the center of the window */
  radius = (winw > winh ? winh : winw) / 4;
  vg4->window->draw_circle(winw / 2, winh / 2, radius, VG_COLOR_YELLOW, VG_TRUE);

  /* flush window contents and wait 3 seconds */
  vg4->window->flush();
  sleep(3);

  /* +++ now set window to grey and draw the circle again +++ */

  /* set window attributes to grey color */
  VG_IMAGECOPY_ATTRPIXEL_DEFAULT(&wattr_pixel);
  wattr_pixel.pixelcolor = VG_PIXELCOLOR_GREY;
  vg4->window->setattr(&wattr_pixel);

  /* clear window and fill it with blue color */
  vg4->window->clear();
  vg4->window->fill(VG_COLOR_BLUE);

  /* draw a yellow filled circle at the center of the window */
  radius = (winw > winh ? winh : winw) / 4;
  vg4->window->draw_circle(winw / 2, winh / 2, radius, VG_COLOR_YELLOW, VG_TRUE);

  /* flush window contents and wait 3 seconds */
  vg4->window->flush();
  sleep(3);

  /* destroy and exit */
  VG_dest();
  exit(0);
}
