/* VgaGames4 tutorial 1 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>

static VG_BOOL show_help(void);

/* keys */
struct {
  int k_quit_lalt;  /* part of quit: Left-ALT */
  int k_quit_q;     /* part of quit: Q */
  int k_pause;      /* pause */
} kref;


/* show help-text */
static VG_BOOL
show_help(void)
{
  char helptext[512];
  size_t hsize;
  struct VG_Image *imgp;
  int k_space;

  /* create text */
  snprintf(helptext, sizeof(helptext), "%%{txt&center[font=sysw:low fgcolor=0xffff00 bold=on]: Pingpong game%%}\n");
  hsize = strlen(helptext);
  snprintf(helptext + hsize, sizeof(helptext) - hsize, "\n\n");
  hsize = strlen(helptext);
  snprintf(helptext + hsize, sizeof(helptext) - hsize, "%%{txt[fgcolor=0x888888]: [ALT+Q]%%}        Quit game\n");
  hsize = strlen(helptext);
  snprintf(helptext + hsize, sizeof(helptext) - hsize, "%%{txt[fgcolor=0x888888]: [P]%%}            Pause\n");
  hsize = strlen(helptext);
  snprintf(helptext + hsize, sizeof(helptext) - hsize, "\n\n");
  hsize = strlen(helptext);
  snprintf(helptext + hsize, sizeof(helptext) - hsize, "%%{txt&center[fgcolor=0xdddddd]: Press space-key%%}\n");
  hsize = strlen(helptext);

  /* create image from text */
  imgp = vg4->font->totext(helptext, "[fgcolor=0xbbbb00 boxwidth=70%%]", NULL, NULL, NULL);
  if (imgp == NULL) { return VG_FALSE; }

  /* set space-key */
  if ((k_space = vg4->input->key_insert("Spacekey", VG_FALSE, VG_FALSE)) == 0) { return VG_FALSE; }
  vg4->input->key_setkbd(k_space, VG_INPUT_KBDCODE_SPACE);

  /* copy image to window */
  vg4->window->clear();
  vg4->window->copy(imgp, NULL, NULL);
  vg4->image->destroy(imgp);

  /* wait for pressing space-key */
  for (;;) {
    if (!vg4->input->update(VG_TRUE)) { return VG_FALSE; }
    if (vg4->input->key_newpressed(k_space)) { break; }
    vg4->window->flush();
    vg4->misc->wait_time(70);
  }
  vg4->window->clear();
  vg4->window->flush();

  /* remove space-key */
  vg4->input->key_remove(k_space);

  return VG_TRUE;
}


int main(int argc, char **argv) {
  const int border_size = 10;  /* size of borders in pixels */
  int winw, winh;  /* window's width and height */
  int audc_bgmusic;  /* audio descriptors */
  struct VG_Rect rect;

  (void)argc; (void)argv;

  /* initialize and open window */
  if (!VG_init("VgaGames4 tutorial 1")) { exit(1); }
  if (!vg4->window->open(VG_WINDOW_SIZE_LOW, VG_WINDOW_SCALE_BEST)) { VG_dest(); exit(1); }
  vg4->window->getsize(&winw, &winh);

  /* set mouse grabbing to off */
  vg4->input->mouse_grabbing(VG_FALSE);

  /* open audio system */
  if (!vg4->audio->open(VG_AUDIO_FREQ_MEDIUM, VG_FALSE)) { VG_dest(); exit(1); }

  /* load audio files */
  audc_bgmusic = vg4->audio->load("files/bgmusic.wav", 50, VG_AUDIO_VOLUME_MUSIC);

  /* set keys */
  /* quit with ALT+Q, not changeable */
  if ((kref.k_quit_lalt = vg4->input->key_insert("Quit-LALT", VG_FALSE, VG_FALSE)) == 0) { VG_dest(); exit(1); }
  vg4->input->key_setkbd(kref.k_quit_lalt, VG_INPUT_KBDCODE_LALT);
  if ((kref.k_quit_q = vg4->input->key_insert("Quit-Q", VG_FALSE, VG_FALSE)) == 0) { VG_dest(); exit(1); }
  vg4->input->key_setkbd(kref.k_quit_q, VG_INPUT_KBDCODE_Q);
  /* pause with P, changeable */
  if ((kref.k_pause = vg4->input->key_insert("Pause", VG_TRUE, VG_FALSE)) == 0) { VG_dest(); exit(1); }
  vg4->input->key_setkbd(kref.k_pause, VG_INPUT_KBDCODE_P);

  /* show help */
  if (!show_help()) { VG_dest(); exit(1); }

  /* play background music looping */
  vg4->audio->play(audc_bgmusic, VG_TRUE, VG_TRUE);

  /* game loop */
  for (;;) {
    /* retrieve input-events */
    if (!vg4->input->update(VG_TRUE)) { goto endgame; }

    /* quit? */
    if (vg4->input->key_newpressed(kref.k_quit_q) && vg4->input->key_pressed(kref.k_quit_lalt)) { goto endgame; }

    /* pause? */
    if (vg4->input->key_newpressed(kref.k_pause)) {
      if (!vg4->misc->pause()) { goto endgame; }
    }

    /* +++ draw out +++ */

    /* clear window */
    vg4->window->clear();

    /* draw background and borders */
    vg4->window->fill(vg4->misc->colorbrightness(VG_COLOR_BLUE, 50));
    /* top border */
    rect.x = rect.y = 0; rect.w = winw; rect.h = border_size;
    vg4->window->draw_rect(&rect, VG_COLOR_RGB(0xb1, 0, 0), VG_TRUE);
    /* bottom border */
    rect.x = 0; rect.y = winh - border_size; rect.w = winw; rect.h = border_size;
    vg4->window->draw_rect(&rect, VG_COLOR_RGB(0xb1, 0, 0), VG_TRUE);
    /* right border */
    rect.x = winw - border_size; rect.y = 0; rect.w = border_size; rect.h = winh;
    vg4->window->draw_rect(&rect, VG_COLOR_RGB(0xb1, 0, 0), VG_TRUE);


    /* flush contents to window and wait */
    vg4->window->flush();
    vg4->misc->wait_time(40);
  }

endgame:
  /* destroy and exit */
  VG_dest();
  exit(0);
}
