/* load an audio file, play it and wait for its end */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>

int main(int argc, char **argv) {
  int audc;

  (void)argc; (void)argv;

  /* initialize, but we don't need a window */
  if (!VG_init("test")) { exit(1); }

  /* open audio system */
  if (!vg4->audio->open(VG_AUDIO_FREQ_MEDIUM, VG_TRUE)) { VG_dest(); exit(1); }

  /* load audio file */
  audc = vg4->audio->load("audio.wav", 100, VG_AUDIO_VOLUME_MUSIC);
  if (audc == 0) { VG_dest(); exit(1); }
  printf("%s loaded\n", vg4->audio->getname(audc));

  /* play audio */
  vg4->audio->play(audc, VG_FALSE, VG_FALSE);

  /* wait until audio playing has been ended */
  for (;;) {
    if (!vg4->audio->is_playing(audc, NULL)) { break; }
    sleep(1);
  }

  /* unload audio */
  vg4->audio->unload(audc);

  /* destroy and exit */
  VG_dest();
  exit(0);
}
